/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.container;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.ArchiveNotFoundException;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.archive.container.SimpleContainer;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.config.ConfiguredContainersConfig;
import de.lwsystems.mailarchive.config.ContainerConfig;
import de.lwsystems.mailarchive.config.IContainerConfig;
import de.lwsystems.mailarchive.config.ISimpleContainerConfig;
import de.lwsystems.mailarchive.config.RedundancyContainerConfig;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfiguredContainerGenerator
implements IContainerGenerator {
    private static final Logger LOGGER = Logger.getLogger(ConfiguredContainerGenerator.class);
    private final Map<String, IContainer> containers;
    private final IArchive archive;
    private final Benno benno;
    private final boolean readOnly;

    public ConfiguredContainerGenerator(Benno benno, IArchive archive, ConfiguredContainersConfig config, boolean readOnly) throws IOException, ConfigurationException {
        this.archive = archive;
        this.benno = benno;
        this.readOnly = readOnly;
        this.containers = new HashMap<String, IContainer>();
        this.updateContainers(config);
    }

    private void updateContainers(ConfiguredContainersConfig config) throws ConfigurationException {
        Object container;
        HashSet<String> unconfiguredContainers = new HashSet<String>();
        unconfiguredContainers.addAll(this.getContainerMap().keySet());
        for (ContainerConfig container2 : config.containers) {
            this.configureContainerInContainerMap(container2, true);
        }
        if (config.redundancyContainers != null && config.redundancyContainers.stream().count() > 0L) {
            for (RedundancyContainerConfig redundancyContainer : config.redundancyContainers) {
                container = new ContainerConfig(redundancyContainer.getIdentifier(), redundancyContainer.getCondition(), redundancyContainer.isReadOnly(), null, redundancyContainer.getBoxGenerator(), redundancyContainer.isScidActive());
                this.configureContainerInContainerMap((ContainerConfig)container, false);
            }
        }
        for (String identifier : unconfiguredContainers) {
            container = this.getContainerMap().get(identifier);
            container.close();
            this.removeContainer(identifier);
        }
    }

    private void configureContainerInContainerMap(ContainerConfig container, boolean indexActive) throws ConfigurationException {
        try {
            if (this.getContainerMap().containsKey(container.identifier)) {
                this.getContainerMap().get(container.identifier).configure(container);
            } else {
                this.addContainer(container.identifier, this.getContainer(this.benno, container, this.readOnly, indexActive));
            }
        }
        catch (ArchiveException ex) {
            LOGGER.error(null, (Throwable)ex);
        }
        catch (IOException e) {
            throw new ConfigurationException((IBoxHolder)this.getArchive(), e);
        }
    }

    private IContainer getContainer(Benno benno, IContainerConfig container, boolean readOnly, boolean indexActive) throws ArchiveException, IOException {
        if (container instanceof ISimpleContainerConfig) {
            ISimpleContainerConfig containerConfig = (ISimpleContainerConfig)container;
            if (indexActive) {
                return new SimpleContainer.Builder(this.archive, containerConfig.getBoxGenerator(), container.getCondition(), container.getIdentifier(), readOnly, container.isScidActive()).activateIndex(benno, container.getIndex()).build();
            }
            return new SimpleContainer.Builder(this.archive, containerConfig.getBoxGenerator(), container.getCondition(), container.getIdentifier(), readOnly, container.isScidActive()).build();
        }
        throw new RuntimeException("bad config");
    }

    @Override
    public final IArchive getArchive() {
        return this.archive;
    }

    protected final Map<String, IContainer> getContainerMap() {
        return this.containers;
    }

    @Override
    public final Iterable<IContainer> getContainers() {
        return this.containers.values();
    }

    @Override
    public final IContainer getContainer(String name) throws ArchiveNotFoundException {
        IContainer container = this.containers.get(name);
        if (container == null) {
            throw new ArchiveNotFoundException(name);
        }
        return container;
    }

    protected final void addContainer(String identifier, IContainer container) {
        this.containers.put(identifier, container);
    }

    protected final void removeContainer(String identifier) {
        this.containers.remove(identifier);
    }

    @Override
    public ArchivedMailDocument addDocument(MailDocument document) throws FailedArchivingException, NonFailingArchivingException {
        ArchivedMailDocument archivedMailDocument = null;
        int containerCounter = 0;
        for (IContainer container : this.getContainers()) {
            ++containerCounter;
            try {
                if (!container.getIdentifier().toLowerCase().equals("sysdata") && container.isScidActive() && document.getMetaData().getScid().equals("")) {
                    FailedArchivingException fae = new FailedArchivingException(document, "There is no SCID Tag in mail for identifying the correct container");
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.warn((Object)("Message not archived in container \"" + container.getIdentifier() + "\": " + fae.toString()));
                    continue;
                }
                archivedMailDocument = container.addDocument(document);
                if (!LOGGER.isInfoEnabled()) continue;
                String scidPath = "";
                if (container.isScidActive()) {
                    scidPath = document.getMetaData().getScid() + "/";
                }
                LOGGER.info((Object)("Store Message in container " + container.getIdentifier() + "/" + scidPath + archivedMailDocument.getFullDocumentId()));
            }
            catch (NonFailingArchivingException ex) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Message not archived in container \"" + container.getIdentifier() + "\""), (Throwable)ex);
            }
        }
        if (containerCounter == 0) {
            throw new FailedArchivingException(document, "No write permission on any container");
        }
        if (archivedMailDocument == null) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria of any container");
        }
        return archivedMailDocument;
    }

    @Override
    public void removeDocument(MailDocument document, String mode) throws ArchiveException, IOException, FailedArchivingException, NonFailingArchivingException {
        int containerCounter = 0;
        RemovedMailDocument removedMailDocument = null;
        for (IContainer container : this.getContainers()) {
            ++containerCounter;
            try {
                removedMailDocument = container.removeDocument(document, mode);
            }
            catch (NonFailingArchivingException ex) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Message not removed from container \"" + container.getIdentifier() + "\""), (Throwable)ex);
            }
        }
        if (containerCounter == 0) {
            throw new FailedArchivingException(document, "No write permission on any container");
        }
        if (removedMailDocument == null) {
            throw new NonFailingArchivingException(document, "Document does not match archiving criteria of any container");
        }
    }

    public boolean optimizeIndex() {
        boolean successful = true;
        for (IContainer container : this.getContainers()) {
            successful = container.optimizeIndex() && successful;
        }
        return successful;
    }

    @Override
    public void shutdown() {
        for (IContainer container : this.getContainers()) {
            container.close();
        }
    }

    @Override
    public void configure(ConfiguredContainersConfig config) throws ConfigurationException {
        this.updateContainers(config);
    }

    @Override
    public void addRemoveRepoJournalEntry(MailDocument document) throws FailedArchivingException {
        int containerCounter = 0;
        Object removedMailDocument = null;
        for (IContainer container : this.getContainers()) {
            ++containerCounter;
            boolean bl = container.addRemoveRepoJournalEntry(document);
        }
    }
}

