/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.index;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.config.IIndexConfig;
import de.lwsystems.mailarchive.config.LuceneIndexConfig;
import de.lwsystems.mailarchive.index.AbstractIndex;
import de.lwsystems.mailarchive.index.LuceneIndexWriter;
import de.lwsystems.mailarchive.index.LuceneUtils;
import de.lwsystems.mailarchive.index.ObservedDocument;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.DocumentListener;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LuceneIndex
extends AbstractIndex {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class);
    private final Benno benno;
    private final String directoryPath;
    private boolean debugEnabled = LOGGER.isDebugEnabled();
    public static final Version STANDARDVERSION = Version.LUCENE_33;
    private final boolean readOnly;
    private final Version version;
    private final Integer indexTimeout;
    private LuceneIndexWriter LuceneIndexWriter;
    private Directory directory;

    public LuceneIndex(Benno benno, IBoxHolder boxHolder, String directory) throws ArchiveException, IOException {
        this(benno, boxHolder, directory, true, (Integer)120);
    }

    public LuceneIndex(Benno benno, IBoxHolder boxHolder, String directory, boolean readOnly, Integer indexTimeout) throws ArchiveException, IOException {
        this(benno, boxHolder, new File(directory), STANDARDVERSION, readOnly, indexTimeout);
    }

    public LuceneIndex(Benno benno, IBoxHolder boxHolder, File directory, boolean readOnly, Integer indexTimeout) throws ArchiveException, IOException {
        this(benno, boxHolder, directory, STANDARDVERSION, readOnly, indexTimeout);
    }

    public LuceneIndex(Benno benno, IBoxHolder boxHolder, File directory, Version version, boolean readOnly, Integer indexTimeout) throws ArchiveException, IOException {
        super(boxHolder);
        this.benno = benno;
        this.directoryPath = directory.getPath();
        this.version = version;
        this.readOnly = readOnly;
        this.indexTimeout = indexTimeout;
        this.initIndexWriter(directory);
    }

    public LuceneIndex(Benno benno, IBoxHolder boxHolder, LuceneIndexConfig config) throws ArchiveException, IOException {
        this(benno, boxHolder, new File(config.getDirectory()), config.getVersion(), boxHolder.isReadOnly(), config.indexTimeout);
    }

    private void initIndexWriter(File directory) throws ArchiveException, IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            LOGGER.fatal((Object)("Luceneindexdirectory cannot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\""));
            throw new RuntimeException("Luceneindexdirectory cannot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.exists()) {
            LOGGER.fatal((Object)("Luceneindexdirectory cannot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\""));
            throw new RuntimeException("Luceneindexdirectory cannot be created. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.isDirectory()) {
            LOGGER.fatal((Object)("Luceneindexdirectory is not a directory. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\""));
            throw new RuntimeException("Luceneindexdirectory is not a directory. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!directory.canRead()) {
            LOGGER.fatal((Object)("Luceneindexdirectory cannot be read. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\""));
            throw new RuntimeException("Luceneindexdirectory cannot be read. (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!this.readOnly && !directory.canWrite()) {
            String username = System.getProperty("user.name");
            LOGGER.fatal((Object)("Luceneindexdirectory is not a writeable for user " + username + ". (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\""));
            throw new RuntimeException("Luceneindexdirectory is not a writeable for user " + username + ". (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        try {
            this.directory = FSDirectory.open((File)directory);
        }
        catch (IOException ex) {
            LOGGER.fatal((Object)("Directory cannot be opened (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\""));
            throw new RuntimeException("Directory cannot be opened  (" + this.getIdentifier() + "): \"" + directory.getAbsolutePath() + "\"");
        }
        if (!this.readOnly) {
            this.LuceneIndexWriter = new LuceneIndexWriter(this, this.directory, this.version, this.indexTimeout);
        }
    }

    @Override
    public IIndexConfig getConfig() {
        throw new UnsupportedOperationException();
    }

    public void closeIndexWriter() throws CorruptIndexException, IOException {
        this.LuceneIndexWriter.close();
    }

    @Override
    public String getIdentifier() {
        StringBuilder idString = new StringBuilder("LuceneIndex ");
        if (this.version == null) {
            idString.append("versionless");
        } else {
            idString.append(this.version.toString());
        }
        if (this.directory != null) {
            idString.append(": \"").append(this.directory.toString()).append("\"");
        }
        return idString.toString();
    }

    @Override
    public void addDocument(final ArchivedMailDocument mailId) throws FailedArchivingException {
        ObservedDocument document = LuceneUtils.createLuceneDocument(this.benno, mailId);
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void indexingFinished() {
                mailId.getDocument().indexingFinished();
            }

            @Override
            public void removingFinished() {
            }

            @Override
            public void indexingError(Exception ex) {
                mailId.getDocument().indexingError(ex);
            }
        });
        this.addDocument(document, mailId.getDocument());
    }

    private void addDocument(ObservedDocument document, MailDocument mail) throws FailedArchivingException {
        try {
            this.LuceneIndexWriter.addDocument(document);
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Cannot index message \"" + mail.toString()), (Throwable)ex);
            throw new FailedArchivingException(mail, ex);
        }
    }

    @Override
    public void removeDocument(final RemovedMailDocument document, String mode) throws IOException, FailedArchivingException {
        ArchivedMailDocument archivedMailDocument = new ArchivedMailDocument(document.getDocument(), document.getMailDocumentId());
        ObservedDocument observedDocument = LuceneUtils.createLuceneDocument(this.benno, archivedMailDocument);
        observedDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void indexingFinished() {
            }

            @Override
            public void removingFinished() {
                document.getDocument().removingFinished();
            }

            @Override
            public void indexingError(Exception ex) {
            }
        });
        try {
            this.LuceneIndexWriter.removeDocument(observedDocument, mode);
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Cannot remove message \"" + document.getDocument().toString()), (Throwable)ex);
            throw new FailedArchivingException(document.getDocument(), ex);
        }
    }

    @Override
    public boolean optimize() {
        boolean successful = false;
        try {
            successful = this.LuceneIndexWriter.optimize();
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
        return successful;
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    @Override
    public String getIndexPathString() {
        return this.directoryPath;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void close() {
        try {
            if (!this.readOnly) {
                this.closeIndexWriter();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not shut down Lucene index", (Throwable)e);
        }
    }

    @Override
    public void configure(IIndexConfig index) throws ConfigurationException {
        if (index instanceof LuceneIndexConfig) {
            LuceneIndexConfig indexConfig = (LuceneIndexConfig)index;
            String directory = indexConfig.getDirectory();
            if (!Paths.get(directory, new String[0]).equals(Paths.get(this.directoryPath, new String[0]))) {
                throw new ConfigurationException(this.getBoxHolder(), "index directory cannot be changed on the fly");
            }
        } else {
            throw new ConfigurationException(this.getBoxHolder(), "invalid lucene index configuration");
        }
    }
}

