/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.maildocument;

import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.PreviousArchive;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.ConversionException;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import de.lwsystems.mailarchive.utils.CustomHash;
import de.lwsystems.mailarchive.utils.ListUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;

@Root(name="metadata")
public class MailMetaData {
    private static final Logger LOGGER = Logger.getLogger(MailMetaData.class);
    private final DateFormat dateFormat;
    @Attribute(name="hash")
    private final String hash;
    private final String bennohash;
    private final String standardChecksum;
    @ElementArray(name="customhash", entry="custom-hash", required=false)
    private final String[] customHashList;
    @ElementArray(name="senders", entry="sender", data=true)
    private final String[] senderList;
    @ElementArray(name="recipients", entry="recipient", data=true)
    private final String[] recipientList;
    @ElementArray(name="from", entry="sender", data=true)
    private final String[] fromList;
    @ElementArray(name="to", entry="recipient", data=true)
    private final String[] toList;
    @ElementArray(name="cc", required=false, entry="recipient", data=true)
    private final String[] ccList;
    @ElementArray(name="headers", entry="header")
    private final Header[] headers;
    @ElementArray(name="headers", entry="secret-headers")
    private final Header[] secretHeaders;
    @ElementArray(name="archives", entry="archive", required=false)
    private final PreviousArchive[] archives;
    @Attribute(name="date", required=false)
    private final Date date;
    @Attribute(name="timezone", required=false)
    private String timezone = "";
    @Attribute(name="hasattachment", required=false)
    private final boolean attached;
    @Attribute(name="customhashactive", required=false)
    private final boolean customHash;
    @Attribute(name="size", required=false)
    private final int size;
    @Attribute(name="defective", required=false)
    private final boolean defective;
    private String scid = "";
    private String[] senderDomains = null;
    private String[] recipientDomains = null;
    private String[] fromDomains = null;
    private String[] toDomains = null;
    private String[] ccDomains = null;

    private static Persister getPersister() {
        return new Persister((Strategy)new TreeStrategy("type", "count"));
    }

    public void Serialize(OutputStream out) throws Exception {
        MailMetaData.getPersister().write((Object)this, out);
    }

    public MailMetaData(String hash, String bennohash, String[] senders, String[] recipients, String[] from, String[] to, String[] cc, Date date, boolean attached, int size, Header[] headers, Header[] secretHeaders, PreviousArchive[] archives, boolean defective, String[] customHashList, String standardChecksum, boolean customHash, String timezone) {
        this.hash = hash;
        this.bennohash = bennohash;
        this.standardChecksum = standardChecksum;
        this.customHashList = customHashList;
        this.customHash = customHash;
        this.senderList = senders;
        this.recipientList = recipients;
        this.fromList = from;
        this.toList = to;
        this.ccList = cc;
        this.date = date != null ? date : Clock.getProvider().newDate();
        if (timezone != null) {
            this.timezone = timezone;
        }
        this.attached = attached;
        this.size = size;
        this.headers = headers;
        this.secretHeaders = secretHeaders;
        this.archives = archives;
        for (Header secretHeader : headers) {
            if (!secretHeader.getName().equals("X-BENNO-SCID")) continue;
            this.scid = secretHeader.getBody();
        }
        this.defective = defective;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ROOT);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String toString() {
        return this.getHashHex();
    }

    public byte[] getHash() {
        byte[] hashcode = null;
        try {
            hashcode = ConversionUtil.fromHexToBytes(this.hash);
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return hashcode;
    }

    public String getHashHex() {
        return this.hash;
    }

    public String getBennoHashHex() {
        return this.getBennohash();
    }

    public String getStandardChecksum() {
        return this.standardChecksum;
    }

    public String getHashB64() {
        return ConversionUtil.fromBytesToB64(this.getHash());
    }

    public boolean matchSender(String mailAddress, boolean matchRegex) {
        return this.matchList(mailAddress, this.getSenders(), matchRegex);
    }

    public boolean matchRecipient(String mailAddress, boolean matchRegex) {
        return this.matchList(mailAddress, this.getRecipients(), matchRegex);
    }

    public boolean matchFrom(String mailAddress, boolean matchRegex) {
        return this.matchList(mailAddress, this.getFroms(), matchRegex);
    }

    public boolean matchTo(String mailAddress, boolean matchRegex) {
        return this.matchList(mailAddress, this.getTos(), matchRegex);
    }

    public boolean matchCc(String mailAddress, boolean matchRegex) {
        return this.matchList(mailAddress, this.getCcs(), matchRegex);
    }

    public boolean matchSenderDomain(String domain, boolean matchRegex) {
        return this.matchList(domain, this.getSenderDomains(), matchRegex);
    }

    public boolean matchRecipientDomain(String domain, boolean matchRegex) {
        return this.matchList(domain, this.getRecipientDomains(), matchRegex);
    }

    public boolean matchFromDomain(String domain, boolean matchRegex) {
        return this.matchList(domain, this.getFromDomains(), matchRegex);
    }

    public boolean matchToDomain(String domain, boolean matchRegex) {
        return this.matchList(domain, this.getToDomains(), matchRegex);
    }

    public boolean matchCcDomain(String domain, boolean matchRegex) {
        return this.matchList(domain, this.getCcDomains(), matchRegex);
    }

    private boolean matchList(String single, String[] list, boolean matchRegex) {
        boolean bRet = false;
        Pattern pattern = Pattern.compile(single);
        for (int i = 0; !bRet && i < list.length; ++i) {
            Matcher matcher = pattern.matcher(list[i]);
            bRet = bRet || matchRegex ? matcher.matches() : list[i].equalsIgnoreCase(single);
        }
        return bRet;
    }

    public synchronized String[] getSenderDomains() {
        if (this.senderDomains == null) {
            this.senderDomains = ListUtil.extractDomains(this.getSenders());
        }
        return this.senderDomains;
    }

    public synchronized String[] getRecipientDomains() {
        if (this.recipientDomains == null) {
            this.recipientDomains = ListUtil.extractDomains(this.getRecipients());
        }
        return this.recipientDomains;
    }

    public synchronized boolean hasAttachment() {
        return this.attached;
    }

    public synchronized boolean customHashActive() {
        return this.customHash;
    }

    public synchronized String[] getFromDomains() {
        if (this.fromDomains == null) {
            this.fromDomains = ListUtil.extractDomains(this.getFroms());
        }
        return this.fromDomains;
    }

    public synchronized String[] getToDomains() {
        if (this.toDomains == null) {
            this.toDomains = ListUtil.extractDomains(this.getTos());
        }
        return this.toDomains;
    }

    public synchronized String[] getCcDomains() {
        if (this.ccDomains == null) {
            this.ccDomains = ListUtil.extractDomains(this.getCcs());
        }
        return this.ccDomains;
    }

    public void appendBennoHeaders(OutputStream outStream) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outStream, "UTF-8");
            writer.write(this.getBennoHeaders());
            writer.flush();
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getBennoHeaders() {
        StringBuilder headerLines = new StringBuilder(1024);
        this.appendBennoHeaders(headerLines);
        return headerLines.toString();
    }

    public void appendBennoHeaders(StringBuilder stringBuilder) {
        if (this.getSenders() != null) {
            for (String sender : this.getSenders()) {
                stringBuilder.append("Sender: ").append(sender).append("\r\n");
            }
        }
        if (this.getRecipients() != null) {
            for (String recipient : this.getRecipients()) {
                stringBuilder.append("Recipient: ").append(recipient).append("\r\n");
            }
        }
        if (this.getSecretHeaders() != null) {
            for (Header secretHeader : this.getSecretHeaders()) {
                stringBuilder.append(secretHeader.getHeaderline()).append("\r\n");
            }
        }
        if (this.getPreviousArchives() != null) {
            for (PreviousArchive archive : this.getPreviousArchives()) {
                archive.appendHeaderlines(stringBuilder);
            }
        }
        if (this.isDefective()) {
            stringBuilder.append("Defective: YES").append("\r\n");
        }
        if (this.isAttached()) {
            stringBuilder.append("Attachments: YES").append("\r\n");
        }
        if (this.getSize() > 0) {
            stringBuilder.append("Size: ").append(this.getSize()).append("\r\n");
        }
        stringBuilder.append("Date: ").append(this.dateFormat.format(this.getDate())).append("\r\n");
        if (this.scid.length() > 0) {
            stringBuilder.append("SCID: ").append(this.getScid()).append("\r\n");
        }
        if (this.timezone.length() > 0) {
            stringBuilder.append("Timezone: ").append(this.getTimezone()).append("\r\n");
        }
        if (this.getCustomHashParameterList().length > 0) {
            stringBuilder.append("CustomHash: YES").append("\r\n");
            for (String customHashParameterValue : this.getCustomHashParameterList()) {
                stringBuilder.append("CustomHashParameter: ").append(customHashParameterValue).append("\r\n");
            }
            stringBuilder.append("StandardChecksum: ").append(this.getStandardChecksum()).append("\r\n");
            stringBuilder.append("===== Hash: ").append(CustomHash.createCustomHash(this.getCustomHashParameterList(), this.getHashHex())).append("\r\n");
        } else {
            stringBuilder.append("===== Hash: ").append(this.getHashHex()).append("\r\n");
        }
    }

    public boolean hashesMatch() {
        try {
            return this.getStandardChecksum().equalsIgnoreCase(this.getHashHex());
        }
        catch (NullPointerException ex) {
            return this.getBennohash().equalsIgnoreCase(this.getHashHex());
        }
    }

    public String getBennohash() {
        return this.bennohash;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String[] getCustomHashParameterList() {
        return this.customHashList;
    }

    public String[] getSenders() {
        return this.senderList;
    }

    public String[] getRecipients() {
        return this.recipientList;
    }

    public String[] getFroms() {
        return this.fromList;
    }

    public String[] getTos() {
        return this.toList;
    }

    public String[] getCcs() {
        return this.ccList;
    }

    public PreviousArchive[] getPreviousArchives() {
        return this.archives;
    }

    public boolean isDefective() {
        return this.defective;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public int getSize() {
        return this.size;
    }

    public Header[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public String getScid() {
        return this.scid;
    }
}

