/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.archive.box;

import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.BennoBox;
import de.lwsystems.mailarchive.archive.box.BoxGeneratorState;
import de.lwsystems.mailarchive.archive.box.BoxState;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.IBoxGenerator;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.archive.box.INameIteratorStrategy;
import de.lwsystems.mailarchive.archive.journal.ClosedBoxJournalEntry;
import de.lwsystems.mailarchive.archive.storage.BoxStorageEngine;
import de.lwsystems.mailarchive.config.BoxConfig;
import de.lwsystems.mailarchive.config.BoxEncryption;
import de.lwsystems.mailarchive.config.BoxGeneratorConfig;
import de.lwsystems.mailarchive.config.ConfigurationException;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.PersistenceUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BoxGenerator
implements IBoxGenerator {
    private static final Logger LOGGER = Logger.getLogger(BoxGenerator.class);
    private final boolean readOnly;
    private final INameIteratorStrategy boxNameIteratorStrategy;
    private final IBoxHolder boxHolder;
    private final BoxGeneratorConfig generatorConfig;
    private BoxGeneratorState state;

    BoxGenerator(IBoxHolder boxHolder, BoxGeneratorConfig config, INameIteratorStrategy boxNameIteratorStrategy, boolean readOnly) throws ArchiveException {
        this.boxHolder = boxHolder;
        this.generatorConfig = config;
        this.boxNameIteratorStrategy = boxNameIteratorStrategy;
        this.readOnly = readOnly;
        this.setState(BoxGenerator.getBoxGeneratorState(config));
    }

    private static BoxGeneratorState getBoxGeneratorState(BoxGeneratorConfig config) {
        BoxGeneratorState state = null;
        File boxStateFile = new File(config.getDirectory() + File.separator + "boxstate.xml");
        if (boxStateFile.exists() && boxStateFile.canRead()) {
            try {
                state = PersistenceUtil.readBoxGeneratorState(boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading boxstate in \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
        if (state == null) {
            state = new BoxGeneratorState();
        }
        return state;
    }

    private void saveState() throws ArchiveException {
        BoxGeneratorState state = this.getState();
        if (state != null) {
            File directory = new File(this.generatorConfig.getDirectory());
            if (!directory.exists()) {
                if (this.readOnly) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" does not exist.");
                }
                if (!directory.mkdirs()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
                if (!directory.exists()) {
                    throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" canot be created.");
                }
            }
            if (!directory.isDirectory()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a directory.");
            }
            if (!this.readOnly && !directory.canWrite()) {
                throw new ArchiveException(this.getBoxHolder(), "Repositorydirectory \"" + directory.getAbsolutePath() + "\" is not a writeable.");
            }
            File boxStateFile = new File(this.generatorConfig.getDirectory() + File.separator + "boxstate.xml");
            try {
                BoxGeneratorState.getPersister().write((Object)state, boxStateFile);
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)("Error writing boxstate to \"" + boxStateFile.getAbsolutePath() + "\""), (Throwable)ex);
            }
        }
    }

    protected String getActualBoxName() {
        return this.boxNameIteratorStrategy.getBoxNameForDate(Clock.getProvider().newDate());
    }

    private synchronized IBox getCurrentBox() throws ArchiveException {
        IBox box = null;
        if (!this.readOnly) {
            String boxName = this.getActualBoxName();
            IBox actualBox = this.getState().getActualBox();
            if (actualBox != null && boxName.equals(actualBox.getIdentifier())) {
                box = actualBox;
            } else {
                IBox oldBox = actualBox;
                String oldHash = null;
                if (oldBox != null) {
                    oldHash = oldBox.closeBox();
                    box = this.getBoxByName(boxName);
                    box.getJournal().addEntry(new ClosedBoxJournalEntry(oldBox.getIdentifier(), oldHash));
                } else {
                    box = this.getBoxByName(boxName);
                }
                this.getState().setActualBox(box);
                this.saveState();
            }
        }
        return box;
    }

    private IBox getBoxByName(String boxName) throws ArchiveException {
        BoxConfig config;
        BoxState boxState = this.state.getBoxes().get(boxName);
        if (boxState == null) {
            config = this.createBoxConfig(boxName);
        } else {
            config = boxState.config;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Using existing box: " + config.getIdentifier()));
            }
            try {
                PersistenceUtil.createPersister().write((Object)boxState, (OutputStream)System.out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new BennoBox(this.getBoxHolder(), config, this.generatorConfig.getDirectory(), this.isReadOnly());
    }

    private BoxConfig createBoxConfig(String boxName) {
        LOGGER.info((Object)("Creating new box: " + boxName));
        BoxConfig boxConfigTemplate = this.generatorConfig.getBoxConfigTemplate();
        BoxConfig boxConfig = new BoxConfig();
        boxConfig.setBoxStorageConfig(BoxStorageEngine.createBoxStorage(boxConfigTemplate.getBoxStorageConfig(), boxName, this.generatorConfig.getDirectory()));
        boxConfig.setCompression(boxConfigTemplate.getCompression());
        boxConfig.setIdentifier(boxName);
        BoxEncryption encryption = boxConfigTemplate.getEncryption();
        if (encryption != null) {
            BoxEncryption boxEncryption = new BoxEncryption();
            boxEncryption.setEngine(encryption.getEngine());
            boxEncryption.setPrivateKeyFile(encryption.getPrivateKeyFile());
            boxEncryption.setPrivateKeyFilePassword(encryption.getPrivateKeyFilePassword());
            boxEncryption.setKeyStoreType(encryption.getKeyStoreType());
            boxEncryption.setKeyPassword(encryption.getKeyPassword());
            boxEncryption.setKeyAlias(encryption.getKeyAlias());
            boxConfig.setEncryption(boxEncryption);
        }
        boxConfig.setJournalConfig(boxConfigTemplate.getJournalConfig());
        boxConfig.setStoragePath(boxConfigTemplate.getStoragePath());
        return boxConfig;
    }

    @Override
    public ArchivedMailDocument addDocument(MailDocument document) throws FailedArchivingException {
        ArchivedMailDocument docid = null;
        if (this.isReadOnly()) {
            throw new FailedArchivingException(document, "BoxGenerator is readonly");
        }
        try {
            IBox box = this.getCurrentBox();
            docid = box.addDocument(document, this.state.getBoxes());
        }
        catch (ArchiveException ex) {
            throw new FailedArchivingException(document, ex);
        }
        return docid;
    }

    @Override
    public RemovedMailDocument removeDocument(MailDocument document, String mode) throws ArchiveException, FailedArchivingException {
        RemovedMailDocument docid = null;
        if (this.isReadOnly()) {
            throw new FailedArchivingException(document, "BoxGenerator is readonly");
        }
        try {
            IBox box = this.getCurrentBox();
            docid = box.removeDocument(document, this.state.getBoxes(), mode);
        }
        catch (ArchiveException ex) {
            throw new FailedArchivingException(document, ex);
        }
        return docid;
    }

    @Override
    public void addRemoveRepoJournalEntry(MailDocument myDoc) throws FailedArchivingException {
        if (this.isReadOnly()) {
            throw new FailedArchivingException(myDoc, "BoxGenerator is readonly");
        }
        try {
            IBox box = this.getCurrentBox();
            box.addRemoveRepoJournalEntry(myDoc);
        }
        catch (ArchiveException ex) {
            throw new FailedArchivingException(myDoc, ex);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected Iterator<String> getBoxNameIterator() {
        return this.boxNameIteratorStrategy.getIterator();
    }

    @Override
    public void configure(BoxGeneratorConfig config) throws ConfigurationException {
        try {
            this.setState(BoxGenerator.getBoxGeneratorState(config));
        }
        catch (ArchiveException e) {
            throw new ConfigurationException(this.getBoxHolder(), e);
        }
    }

    @Override
    public BoxGeneratorConfig getBoxGeneratorConfig() {
        return this.generatorConfig;
    }

    @Override
    public IBox getBox(String boxName) throws ArchiveException {
        return this.getBoxByName(boxName);
    }

    @Override
    public final IBoxHolder getBoxHolder() {
        return this.boxHolder;
    }

    @Override
    public BoxGeneratorState getState() {
        return this.state;
    }

    protected void setState(BoxGeneratorState state) throws ArchiveException {
        this.state = state;
        this.state.setReadOnly(this.boxHolder.isReadOnly());
        this.checkBoxes(this.boxHolder, this.state);
    }

    private void checkBoxes(IBoxHolder holder, BoxGeneratorState state) throws ArchiveException {
        for (Map.Entry<String, BoxState> entry : state.getBoxes().entrySet()) {
            BoxState boxState = entry.getValue();
            if (boxState.state != IBox.BOXSTATE.OPEN) continue;
            if (state.getActualBox() == null) {
                String containerDriver;
                state.setActualBox(this.getBoxByName(entry.getKey()));
                String boxDriver = state.getActualBox().getBoxConfig().getBoxStorageConfig().getDriver();
                if (boxDriver.equalsIgnoreCase(containerDriver = this.getBoxGeneratorConfig().getBoxConfigTemplate().getBoxStorageConfig().getDriver())) continue;
                throw new RuntimeException("Storage backend configuration differs to boxstate configuration, driver mismatch.");
            }
            throw new ArchiveException(holder, "Boxgenerator with two open boxes \"" + this.getActualBoxName() + "\" and \"" + entry.getKey() + "\"");
        }
    }

    @Override
    public void shutdown() {
        this.getBoxHolder().close();
    }
}

