/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.mailservice;

import com.google.common.eventbus.EventBus;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.event.DeliveredEvent;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.maildocument.MailDocumentListener;
import de.lwsystems.mailarchive.maildocument.RemovedMailDocument;
import de.lwsystems.mailarchive.maillistener.FailedArchivingException;
import de.lwsystems.mailarchive.maillistener.IMailListener;
import de.lwsystems.mailarchive.maillistener.NonFailingArchivingException;
import de.lwsystems.mailarchive.parser.IFileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

class BennoFileProcessor {
    private static final Logger LOGGER = Logger.getLogger(BennoFileProcessor.class);
    private final File directory;
    private final IFileParser fileParser;
    private final List<IMailListener> listeners;
    private final EventBus eventBus;
    private boolean destroyed;

    public BennoFileProcessor(File directory, IFileParser fileParser, List<IMailListener> listeners, EventBus eventBus) {
        this.directory = directory;
        this.fileParser = fileParser;
        this.listeners = listeners;
        this.eventBus = eventBus;
    }

    private Path renameFile(Path filePath) throws IOException {
        String incomingFileName = filePath.getFileName().toString();
        String inprocessFilename = incomingFileName.substring(0, incomingFileName.length() - 4) + ".prc";
        Path inprocessFilePath = FileSystems.getDefault().getPath(this.directory.getAbsolutePath(), inprocessFilename);
        Files.move(filePath, inprocessFilePath, StandardCopyOption.ATOMIC_MOVE);
        return inprocessFilePath;
    }

    public void processFile(Path filename) {
        Date date = new Date();
        final long ts = new Timestamp(date.getTime()).getTime();
        Path file = null;
        try {
            final Path processedFile = file = this.renameFile(filename);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Read file " + file.toAbsolutePath()));
            }
            MailDocument document = this.fileParser.parseFile(processedFile);
            document.addMailDocumentListener(new MailDocumentListener(){

                @Override
                public void processingCompleted() {
                    try {
                        Files.delete(processedFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOGGER.warn((Object)("Problem deleting .prc email file " + processedFile.toAbsolutePath()), (Throwable)e);
                    }
                }

                @Override
                public void removingCompleted() {
                }

                @Override
                public void processingError(Exception ex) {
                    LOGGER.error((Object)("Error processing file \"" + processedFile.toAbsolutePath() + "\""), (Throwable)ex);
                    try {
                        String incomingFileName = processedFile.getFileName().toString();
                        String errorFileName = incomingFileName.substring(0, incomingFileName.length() - 4);
                        Files.move(processedFile, Paths.get(errorFileName + "-" + String.valueOf(ts) + ".err", new String[0]), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOGGER.warn((Object)("Problem moving to .err email file " + processedFile.toAbsolutePath()));
                    }
                }
            });
            if (this.deliverMail(document)) {
                document.archivingSuccessful();
            } else {
                LOGGER.warn((Object)("Problem archiving email file " + file.toAbsolutePath()));
                String incomingFileName = file.getFileName().toString();
                String errorFileName = incomingFileName.substring(0, incomingFileName.length() - 4);
                Files.move(file, Paths.get(errorFileName + "-" + String.valueOf(ts) + ".err", new String[0]), new CopyOption[0]);
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error((Object)"Listed file not found (had been removed before it could be read", (Throwable)ex);
        }
        catch (FileSystemException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ParserException ex) {
            LOGGER.error((Object)("Error parsing file \"" + file.toAbsolutePath() + "\""), (Throwable)ex);
            try {
                String incomingFileName = file.getFileName().toString();
                String errorFileName = incomingFileName.substring(0, incomingFileName.length() - 4);
                Files.move(file, Paths.get(errorFileName + "-" + String.valueOf(ts) + ".err", new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.warn((Object)("Problem moving to .err email file " + file.toAbsolutePath()), (Throwable)e);
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"File could not be moved", (Throwable)ex);
        }
    }

    public boolean removeDocument(MailDocument document, String mode) throws IOException, MessagingException, ParserException {
        document.addMailDocumentListener(new MailDocumentListener(){

            @Override
            public void processingCompleted() {
            }

            @Override
            public void removingCompleted() {
            }

            @Override
            public void processingError(Exception ex) {
            }
        });
        this.deliverRemoveDocument(document, mode);
        return true;
    }

    protected boolean deliverRemoveDocument(MailDocument document, String mode) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    RemovedMailDocument removedMailDocument = listener.removeDocument(document, mode);
                }
                catch (ArchiveException e) {
                    e.printStackTrace();
                }
                catch (FailedArchivingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NonFailingArchivingException e) {
                    e.printStackTrace();
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(document));
            }
        } else {
            successful = false;
        }
        return successful;
    }

    protected boolean deliverMail(MailDocument mail) {
        boolean successful = true;
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    ArchivedMailDocument archivedMailDocument = listener.addDocument(mail);
                }
                catch (NonFailingArchivingException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Email \"" + mail.toString() + "\" was not archived by \"" + listener.toString() + "\""), (Throwable)ex);
                    }
                    mail.indexingFinished();
                }
                catch (FailedArchivingException ex) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("Problem archiving email " + ex));
                    }
                    successful = false;
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(mail));
            }
        } else {
            successful = false;
        }
        return successful;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public void addRemoveRepoJournalEntry(MailDocument document) {
        if (!this.isDestroyed()) {
            for (IMailListener listener : this.listeners) {
                try {
                    listener.addRemoveRepoJournalEntry(document);
                }
                catch (FailedArchivingException | NonFailingArchivingException e) {
                    e.printStackTrace();
                }
            }
            if (this.eventBus != null) {
                this.eventBus.post((Object)new DeliveredEvent(document));
            }
        }
    }
}

