/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.utils;

import java.net.JarURLConnection;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public abstract class BennoBuildTime {
    private static final Logger LOGGER = Logger.getLogger(BennoBuildTime.class);

    public static String archiveBuildTime() {
        try {
            String archiveClass = "de/lwsystems/mailarchive/bennoarchive/BennoArchive.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource(archiveClass).openConnection();
            long buildTS = jarConnection.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
            String buildTime = formatter.format(buildTS);
            return buildTime;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot read bennoarchive build time");
            LOGGER.error((Object)e);
            return "000000000000";
        }
    }

    public static String coreBuildTime() {
        try {
            String coreClass = "de/lwsystems/mailarchive/Benno.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource(coreClass).openConnection();
            long buildTS = jarConnection.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
            String buildTime = formatter.format(buildTS);
            return buildTime;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot read bennocore build time");
            LOGGER.info((Object)e);
            return "20000000000000";
        }
    }

    public static String restBuildTime() {
        try {
            String restClass = "de/lwsystems/mailarchive/rest/BennoRest.class";
            JarURLConnection jarConnection = (JarURLConnection)ClassLoader.getSystemResource(restClass).openConnection();
            long buildTS = jarConnection.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
            String buildTime = formatter.format(buildTS);
            return buildTime;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot read bennocore build time");
            LOGGER.error((Object)e);
            return "000000000000";
        }
    }
}

