#!/bin/sh
# postinst script for benno-exchange
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
        . /usr/share/debconf/confmodule
        db_get benno-exchange/exchange_hostname
        EX_HOST=$RET
        db_get benno-exchange/exchange_user
        EX_USER=$RET
        db_get benno-exchange/exchange_pass
        EX_PASS=$RET
        db_get benno-exchange/exchange_ssl
        EX_SSL=$RET

        perl -pi -e "s/^host\s=.*/host = $EX_HOST/" /etc/benno-exchange/benno-exchange.conf
        perl -pi -e "s/^user\s=.*/user = $EX_USER/" /etc/benno-exchange/benno-exchange.conf
        perl -pi -e "s/^pass\s=.*/pass = $EX_PASS/" /etc/benno-exchange/benno-exchange.conf
        perl -pi -e "s/^ssl\s=.*/ssl = $EX_SSL/" /etc/benno-exchange/benno-exchange.conf
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
