#!/bin/sh
# postinst script for benno-exchange
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
        . /usr/share/debconf/confmodule
        db_get benno-exchange/exchange_hostname
        EX_HOST=$RET
        db_get benno-exchange/exchange_user
        EX_USER=$RET
        db_get benno-exchange/exchange_pass
        EX_PASS=$RET
        db_get benno-exchange/exchange_ssl
        EX_SSL=$RET

        perl -pi -se 's/^host\s=.*/host = $ex_host/' -- -ex_host="$EX_HOST" /etc/benno-exchange/benno-exchange.conf
        perl -pi -se 's/^user\s=.*/user = $ex_user/' -- -ex_user="$EX_USER" /etc/benno-exchange/benno-exchange.conf
        perl -pi -se 's/^pass\s=.*/pass = $ex_pass/' -- -ex_pass="$EX_PASS" /etc/benno-exchange/benno-exchange.conf
        perl -pi -se 's/^ssl\s=.*/ssl = $ex_ssl/' -- -ex_ssl="$EX_SSL" /etc/benno-exchange/benno-exchange.conf

        set +e
        chown -R benno /etc/benno-exchange
        chmod 0750 /etc/benno-exchange
        chmod 0640 /etc/benno-exchange/benno-exchange.conf 2>/dev/null
        set -e
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
