################################################################################
package LWs::Exchange2007;

use MIME::Parser;
use MIME::Base64;
use strict;

### LWs::Exchange2007::parse_journalmail($journal_message)
#
# Returns the message with X-REAL-MAILFROM and X-REAL-RCPTTO headers
#
sub parse_journalmail
{
    my ($journal_msg) = @_;

    my $Parser = new MIME::Parser;
    $Parser->output_to_core(1);
    $Parser->extract_nested_messages(0);
    my $Entity = $Parser->parse_data($journal_msg);

    # check journaling header
    unless (defined($Entity->head->get('X-MS-Journal-Report'))) {
        die "Email is not a MS-Journal-Report\n";
    }

    # journal mail structure of Exchange 2007 / 2010
    #
    # layer | type                      |
    # ------+---------------------------+----------------------------
    # 0     | multipart/mixed           |
    # 1     |     text/plain            | envelope information (text || base64)
    # 1     |     message/rfc822        | original email

    # first part contains metadata
    my $MetaData = $Entity->parts(0) or die "Mail does not look like a journalmail.\n";
    my ($sender_header,$senderdata,$onbehalfdata,$sender);
    my @recipients;
    my $BodyHandle = $MetaData->bodyhandle() or die "Mail does not look like a journalmail.\n";
    foreach my $line ($BodyHandle->as_lines) {
        $line =~ s/[\r\n]//g;
        my ($header,$value) = $line =~ /^(\S+):\s+(.+)$/i;
        if ($header =~ /^(Recipient|To|Cc|Bcc)$/i) {
            foreach my $token (split /,?\s+/, $value) {          # FS#600
                next if $token =~ /Expanded:/i;
                push @recipients, $token;
            }
            next;
        }

        if ($header =~ /^Sender$/) { $senderdata = $value; }
        if ($header =~ /^On-Behalf-Of$/i) { $onbehalfdata = $value; }

        if ($onbehalfdata) {
            $sender = $onbehalfdata;
        }
        else {
            $sender = $senderdata;
        }
        if ($sender =~ /\@/) {
            $sender =~ s/\<^smtp:/</;
        }

        next;
    }
    unless ($sender || @recipients) {
        die "No sender information in metadata.\n";
    }

    return $Entity->parts(1)->stringify_body,$sender,@recipients;
}

### EOP ###
1;

