package Benno::Mailfile;
use Digest::SHA;

sub new {
    my $class   = shift;
    my ($content,$mode) = @_;
    my ($buffer,$envelopes);

    my @lines = split /\n/, $content;
    foreach my $line (@lines) {
        if ($line =~ /^X-REAL-(MAILFROM|RCPTTO):/) {
            $envelopes .= $line."\n";
            next;
        }
        $buffer .= $line."\n";
    }
    my $ctx = Digest::SHA->new('256');
    my $digest = uc $ctx->add($buffer)->hexdigest;

    my $msgid;
    foreach my $line (split /\R/, $content) {
        ($msgid) = $line =~ /^Message-ID:\s(.{10,})$/i;
        last if $msgid;
    }

    chomp $msgid;
    $msgid =~ s/[<>]//g;
    $msgid =~ s/\@//g;
    $msgid = 'NOMSGID' unless $msgid;

    my $self = {
        msgid     => $msgid,
        digest    => $digest,
        content   => $content,
        mode      => $mode,
    };
    bless $self, $class;

    return $self;
}


sub digest
{
    my ($self) = @_;

    return $self->{digest};
}


sub msgid
{
    my ($self) = @_;

    return $self->{msgid};
}


sub save
{
    my ($self,$path,$sfx) = @_;
    my $suffix = $sfx or 'eml';
    $suffix =~ s/^\.//;

    my $tmpname = $path.'/'.$self->{digest};
    $tmpname =~ s/\/\//\//g;
    $tmpname .= '.tmp';

    -f $tmpname and die "Cannot save $tmpname: File exists\n";
    open my $fh, '>',$tmpname or die "Cannot write $tmpname: $!\n";
    print $fh $self->{content};
    close $fh or die "Cannot close $tmpname: $!\n";

    (my $emlname = $tmpname) =~ s/\.tmp$//;
    $emlname = $path.'/'.$self->{digest}.'-'.$suffix;

    link($tmpname, $emlname) or die "Cannot link $tmpname to $emlname: $!\n";
    chmod oct $self->{mode}, $emlname;
    unlink $tmpname or die "Cannot remove $tmpname: $!\n";

    return $emlname;
}

### EOP ###
1;
