package Benno::Mailfile;
use Digest::SHA;

sub new {
    my $class   = shift;
    my ($content,$mode) = @_;
    my ($buffer,$envelopes);

    my @lines = split /\n/, $content;
    foreach my $line (@lines) {
        if ($line =~ /^X-REAL-(MAILFROM|RCPTTO):/) {
            $envelopes .= $line."\n";
            next;
        }
        $buffer .= $line."\n";
    }
    my $ctx = Digest::SHA->new('256');
    my $digest = uc $ctx->add($buffer)->hexdigest;

    my $parser = new MIME::Parser;
    $parser->output_to_core(1);
    $header = $parser->parse_data($content)->head;
    my $msgid = $header->get('Message-ID');
    chomp $msgid;
    $msgid =~ s/[<>]//g;
    $msgid =~ s/\@//g;
    $msgid = 'NOMSGID' unless $msgid;

    my $self = {
        msgid     => $msgid,
        digest    => $digest,
        content   => $content,
        mode      => $mode,
    };
    bless $self, $class;

    return $self;
}


sub save
{
    my ($self,$path,$sfx) = @_;
    my $suffix = $sfx or 'eml';
    $suffix =~ s/^\.//;

    my $tmpname = $path.'/'."$self->{msgid}".':'.$self->{digest};
    $tmpname =~ s/\/\//\//g;
    $tmpname .= '.tmp';

    eval {
        open my $fh, '>',$tmpname or die "Cannot write $tmpname: $!\n";
        print $fh $self->{content};
        close $fh or die "Cannot close $tmpname: $!\n";
    };
    if ($@) {   # file name to long?
        $tmpname = $path.'/'.$self->{digest};
        $tmpname =~ s/\/\//\//g;
        $tmpname .= '.tmp';
        open my $fh, '>',$tmpname or die "Cannot write $tmpname: $!\n";
        print $fh $self->{content};
        close $fh or die "Cannot close $tmpname: $!\n";
    }

    (my $emlname = $tmpname) =~ s/\.tmp$/.$suffix/;
    chmod oct $self->{mode}, $tmpname;

    my $ret = link $tmpname, $emlname;
    unlink $tmpname;
    unless($ret) {
        die "Cannot rename $tmpname to $emlname: $!\n";
    }

    return $emlname;
}


### EOP ###
1;



