#!/bin/sh
# postinst script for benno-archive
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

IMAPUSER_TABLE=/usr/share/doc/benno-imap/imapuser.sql
DATABASE_DIR=/var/lib/benno-web
DATABASE_FILE="$DATABASE_DIR/bennoweb.sqlite"


case "$1" in
    configure)
        set +e
        sqlite3 "$DATABASE_FILE" < "$IMAPUSER_TABLE" 2>/dev/null
        chgrp benno "$DATABASE_DIR"
        chgrp benno "$DATABASE_FILE"
        chmod 0770 "$DATABASE_DIR"
        chmod 0660 "$DATABASE_FILE"
    ;;
    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac


exit 0
