#!/bin/sh
# preinst script for benno-archive
#

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    install|upgrade)
        [ -z "$SERVER_HOME" ] && SERVER_HOME=/srv/benno
        [ -z "$SERVER_USER" ] && SERVER_USER=benno
        [ -z "$SERVER_GROUP" ] && SERVER_GROUP=benno
        [ -z "$SERVER_LOG" ] && SERVER_LOG=/var/log/benno
        [ -z "$SERVER_CACHE" ] && SERVER_CACHE=/var/cache/benno-archive

        if ! getent group | grep -q "^$SERVER_GROUP:" ; then
            echo -n "Add group $SERVER_GROUP.."
            addgroup --quiet --system $SERVER_GROUP 2>/dev/null ||true
            echo "..done"
        fi

        test -d $SERVER_HOME || mkdir -p $SERVER_HOME

        if ! getent passwd | grep -q "^$SERVER_USER:"; then
            echo -n "Adding system user $SERVER_USER.."
            adduser --quiet --system --ingroup $SERVER_GROUP --no-create-home \
                    --home $SERVER_HOME \
                    --disabled-password $SERVER_USER 2>/dev/null || true
            echo "..done"
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.



exit 0
