#!/bin/sh
# postinst script for benno-archive
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package

IMAPUSER_TABLE=/usr/share/doc/benno-imap/imapuser.sql
DATABASE_DIR=/var/lib/benno-web
DATABASE_FILE="$DATABASE_DIR/bennoweb.sqlite"
CONF_DIR=/etc/benno-imap
PUBKEY=/etc/benno-imap/benno-imap.pub
SECKEY=/etc/benno-imap/benno-imap.sec

# if which py3compile >/dev/null 2>&1; then
#     py3compile -p benno-imap
# fi
# if which pypy3compile >/dev/null 2>&1; then
#     pypy3compile -p benno-imap  || true
# fi

case "$1" in
    configure)
        set +e
        if [ -f "$DATABASE_FILE" ];then
            sqlite3 "$DATABASE_FILE" < "$IMAPUSER_TABLE" 2>/dev/null
            chgrp benno "$DATABASE_DIR"
            chgrp benno "$DATABASE_FILE"
            chmod 0770 "$DATABASE_DIR"
            chmod 0660 "$DATABASE_FILE"
        else
            echo "WARN --------------------------------------"
            echo "WARN DB file $DATABASE_FILE not found!"
            echo "WARN YOU MUST EXTEND THE DATABASE MANUALLY!"
            echo "WARN --------------------------------------"
        fi

        if [ ! -f $PUBKEY ] && [ ! -f $SECKEY ];then
            /usr/lib/benno-imap/benno-rsakeys -p $PUBKEY -s $SECKEY
            chown benno:benno $SECKEY 2>/dev/null
            chmod 0440 $SECKEY
        fi
        chmod 0750  $CONF_DIR 2>/dev/null
        chown benno:www-data $CONF_DIR 2>/dev/null
    ;;
    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac


exit 0
