import configparser


class Config:
    """Configuration reader and account initialization"""

    def __init__(self,configfile):
        config=configparser.ConfigParser({
            #'archive': [],
            'host': 'localhost',
            'port': '0',
            'role': 'USER',
            'ssl': 'True',
            'store password': 'False',
            'dbname': '/var/lib/benno-web/bennoweb.sqlite',
            'dbhost': 'localhost',
            'dbuser': '',
            'dbpass': '',
            'keyfile': '',
            'keypass': '',
            'logfile':'',
            'extraHeader':'',
            'envelope':False,
            'disabled':False,
            'inboxdir':'/srv/benno/inbox',
            'skipfolders':[],
            'imap_maxlinelength':'1000000',
            'folder_maxfetch':'500',
        })
        self.config=config
        try:
            confighandle=open(configfile,'r')
            config.read_file(confighandle)
            if config.get('DEFAULT','dbtype') == 'sqlite3':
                config.set('DEFAULT','dbname',config.get('DEFAULT','userdb'))
                print('Configuration variables "dbtype" and "userdb" deprecated. You should set "dbname" to path of SQLite DB file')
        except configparser.MissingSectionHeaderError:
            sys.exit("Config file %s: Missing section header" % configfile)
        except configparser.NoOptionError:
            pass



    def get(self,section,option):
        """Fetch configuration value"""
        if self.config.has_section(section):
            return self.config.get(section,option)
        else:
            return self.config.get('DEFAULT',option)


    def getboolean(self,section,option):
        """Fetch configuration value"""
        if self.config.has_section(section):
            return self.config.getboolean(section,option)
        else:
            return self.config.getboolean('DEFAULT',option)



    def getint(self,section,option):
        """Fetch configuration value"""
        if self.config.has_section(section):
            return self.config.getint(section,option)
        else:
            return self.config.getint('DEFAULT',option)



    def set(self,section,option,value):
        """Set configuration value"""
        self.config.set(section,option,value)


    def add_section(self,section):
        """Add section to config object"""
        self.config.add_section(section)


