# -*- coding: utf-8 -*-
#
# Benno MailArchiv
#
# Copyright 2018-2021 LWsystems GmbH
#
# http://www.lw-systems.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <http://www.gnu.org/licenses/>.
import sys

class DB:
    def __init__(self,dbname,dbuser='',dbpass='',dbhost=''):
        self.db=''
        if dbname.startswith('/'):
            import sqlite3
            dbfile=dbname
            try:
                self.conn=sqlite3.connect(dbname)
            except Exception as e:
                sys.exit('Cannot open database "%s": %s' % (dbname,e))
        else:
            import MySQLdb
            dbname=dbname
            dbuser=dbuser
            dbpass=dbpass
            dbhost=dbhost
            try:
                self.conn=MySQLdb.connect(host=dbhost,user=dbuser,passwd=dbpass,db=dbname)
            except Exception as e:
                sys.exit('ERROR: Cannot connect database "%s": %s' % (dbname, e))
        self.conn.text_factory = str


    def cursor(self):
        return self.conn.cursor()

    def close(self):
        return self.conn.close()

    def commit(self):
        return self.conn.commit()

    def rollback(self):
        return self.conn.rollback()
