# -*- coding: utf-8 -*-
#
# Benno MailArchiv
#
# Copyright 2018-2021 LWsystems GmbH
#
# http://www.lw-systems.de/
#
# All rights reserved.
#
# The source code of this program is made available
# under the terms of the GNU Affero General Public License version 3
# (GNU AGPL V3) as published by the Free Software Foundation.
#
# Binary versions of this program provided by Univention to you as
# well as other copyrighted, protected or trademarked materials like
# Logos, graphics, fonts, specific documentations and configurations,
# cryptographic keys etc. are subject to a license agreement between
# you and Univention and not subject to the GNU AGPL V3.
#
# In the case you use this program under the terms of the GNU AGPL V3,
# the program is provided in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License with the Debian GNU/Linux or Univention distribution in file
# /usr/share/common-licenses/AGPL-3; if not, see
# <http://www.gnu.org/licenses/>.
#
import base64

from Cryptodome.Cipher import PKCS1_v1_5
from Cryptodome.PublicKey import RSA
from Cryptodome.Random import get_random_bytes


class RSAkey:

    @staticmethod
    def generate(length=2048):
        return RSA.generate(length).exportKey('PEM')


    @staticmethod
    def encrypt(key,plaintext):
        cipher = PKCS1_v1_5.new(RSA.importKey(key))
        return cipher.encrypt(plaintext.encode())


    @staticmethod
    def decrypt(key,ciphertext):
        cipher = PKCS1_v1_5.new(RSA.importKey(key))
        sentinel = get_random_bytes(32)
        return cipher.decrypt(ciphertext,sentinel)


    def __init__(self,key):
        self.key = RSA.importKey(key)


    def privkey(self,keyformat='PEM'):
        return self.key.exportKey(keyformat)


    def pubkey(self,keyformat='PEM'):
        return self.key.publickey().exportKey(keyformat)
