/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailDelete;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailWrite;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoImportUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailWrite
implements IMailWrite {
    private static final Logger LOGGER = LogManager.getLogger(MailWrite.class);
    private final IMailDelete mailDelete;

    public MailWrite(IMailDelete mailDelete) {
        this.mailDelete = mailDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeMailFromParts(String mailPathString, Mail mail, String fileName, int waitTime) throws IOException {
        Path tmpMail = new File(mailPathString, fileName + ".tmp").toPath();
        Path emlMail = new File(mailPathString, fileName + ".eml").toPath();
        try {
            int savingMailWaitTime = BennoImportUtils.determineWaitTimeInMs(new File(mailPathString), waitTime);
            LOGGER.debug("Waiting {} ms and save as {}", (Object)savingMailWaitTime, (Object)emlMail);
            Thread.sleep(savingMailWaitTime);
            this.writeMailFromPartsToFS(mail, tmpMail);
            this.createLink(tmpMail, emlMail);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save email to {}", (Object)mailPathString, (Object)e);
            throw new IOException("Cannot save mail with checksum " + fileName, e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted while waiting to save mail", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.mailDelete.deleteMailFile(tmpMail);
        }
        return emlMail.toAbsolutePath().toString();
    }

    @Override
    public ByteArrayOutputStream writeMailIntoStreamFromParts(Mail mail) throws IOException {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        BufferedOutputStream outputStream = new BufferedOutputStream(baoStream);
        this.writeMailParts(mail, outputStream);
        outputStream.flush();
        return baoStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeFullMail(String mailPathString, Mail mail, String fileName, int waitTime) throws IOException {
        Path tmpMail = new File(mailPathString, fileName + ".tmp").toPath();
        Path emlMail = new File(mailPathString, fileName + ".eml").toPath();
        try {
            int savingMailWaitTime = BennoImportUtils.determineWaitTimeInMs(new File(mailPathString), waitTime);
            LOGGER.debug("Waiting {} ms and save as {}", (Object)savingMailWaitTime, (Object)emlMail);
            Thread.sleep(savingMailWaitTime);
            this.writeFullMailToFS(mail, tmpMail);
            this.createLink(tmpMail, emlMail);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save email to {}", (Object)mailPathString, (Object)e);
            throw new IOException("Cannot save mail with checksum " + fileName, e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted while waiting to save mail", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.mailDelete.deleteMailFile(tmpMail);
        }
        return emlMail.toAbsolutePath().toString();
    }

    @Override
    public ByteArrayOutputStream writeMailIntoStreamFullMail(Mail mail) throws IOException {
        ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
        BufferedOutputStream outputStream = new BufferedOutputStream(baoStream);
        this.writeFullMail(mail, outputStream);
        outputStream.flush();
        return baoStream;
    }

    private void createLink(Path tmpMail, Path emlMail) throws IOException {
        try {
            LOGGER.debug("Creating link to eml: {} -> {}", (Object)tmpMail, (Object)emlMail);
            Files.createLink(emlMail, tmpMail);
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to create link to eml: {} -> {}. Copy the .tmp file to .eml", (Object)tmpMail, (Object)emlMail, (Object)ex);
            Files.copy(tmpMail, emlMail, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void writeMailFromPartsToFS(Mail mail, Path tmpMail) throws IOException {
        LOGGER.debug("Writing mail to temporary file: {}", (Object)tmpMail);
        try (FileOutputStream mailOutput = new FileOutputStream(tmpMail.toFile());
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(mailOutput);){
            this.writeMailParts(mail, bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        LOGGER.debug("MailImport written to temporary file: {}", (Object)tmpMail);
    }

    private void writeFullMailToFS(Mail mail, Path tmpMail) throws IOException {
        LOGGER.debug("Writing mail to temporary file: {}", (Object)tmpMail);
        try (FileOutputStream mailOutput = new FileOutputStream(tmpMail.toFile());
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(mailOutput);){
            this.writeFullMail(mail, bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        LOGGER.debug("MailImport written to temporary file: {}", (Object)tmpMail);
    }

    private void writeFullMail(Mail mail, BufferedOutputStream outputStream) throws IOException {
        LOGGER.debug("Writing full mail to output stream");
        outputStream.write(mail.getFullMail().toByteArray());
    }

    private void writeMailParts(Mail mail, BufferedOutputStream outputStream) throws IOException {
        if (mail.getBennoGwHeader() != null) {
            outputStream.write(mail.getBennoGwHeader().toString().getBytes());
            LOGGER.trace("Added GW header to mail output");
        }
        if (mail.getSecretHeaders() != null) {
            outputStream.write(mail.getSecretHeaders().toByteArray());
            LOGGER.trace("Added secret headers to mail output");
        }
        if (mail.getRawMail() != null) {
            outputStream.write(mail.getRawMail().toByteArray());
            LOGGER.trace("Added raw mail to mail output");
        }
    }
}

