/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.models.MailHeadersResult;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.IStreamReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailCreator
implements IMailCreator {
    private static final Logger LOGGER = LogManager.getLogger(MailCreator.class);
    private final IStreamReader streamReader;

    public MailCreator(IStreamReader streamReader) {
        this.streamReader = streamReader;
    }

    @Override
    public Mail convertInputStreamToMail(InputStream mailInputStream) throws IOException {
        LOGGER.debug("Converting input stream to mail object");
        MailHeadersResult mailHeadersResult = this.readMailStream(mailInputStream);
        Mail mail = this.createMailObject(mailHeadersResult);
        LOGGER.debug("MailImport object created from input stream");
        return mail;
    }

    private MailHeadersResult readMailStream(InputStream mailInputStream) throws IOException {
        MailHeadersResult mailHeadersResult = this.streamReader.readMailHeaders(mailInputStream);
        mailHeadersResult.addDataToMailOutputStream(this.streamReader.readMailBody(mailInputStream, mailHeadersResult.getCurrentByteOfMail()).toByteArray());
        return mailHeadersResult;
    }

    private Mail createMailObject(MailHeadersResult mailHeadersResult) throws IOException {
        Mail mail = new Mail();
        mail.setSecretHeaders(mailHeadersResult.getSecretHeaderStream());
        mail.setRawMail(mailHeadersResult.getMailOutputStream());
        this.generateFullMail(mailHeadersResult.getBennoGwHeaderList(), mail);
        return mail;
    }

    private void generateFullMail(List<String> bennoGwHeaderList, Mail mail) throws IOException {
        if (!bennoGwHeaderList.isEmpty()) {
            mail.setBennoGwHeaderList(bennoGwHeaderList);
        }
        ByteArrayOutputStream mailStream = new ByteArrayOutputStream();
        if (mail.getBennoGwHeader() != null) {
            mailStream.write(mail.getBennoGwHeader().toString().getBytes());
        }
        if (mail.getSecretHeaders() != null) {
            mailStream.write(mail.getSecretHeaders().toByteArray());
        }
        if (mail.getRawMail() != null) {
            mailStream.write(mail.getRawMail().toByteArray());
        }
        mail.setFullMail(mailStream);
        mailStream.close();
    }
}

