/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services;

import de.lwsystems.mailarchive.bennoimport.core.services.IMailDelete;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailDelete
implements IMailDelete {
    private static final Logger LOGGER = LogManager.getLogger(MailDelete.class);

    @Override
    public void deleteMailFile(Path mailPath) throws NullPointerException {
        Objects.requireNonNull(mailPath, "mailPath must not be null");
        if (Files.exists(mailPath, new LinkOption[0])) {
            try {
                Files.delete(mailPath);
                LOGGER.debug("The following file was deleted: {}", (Object)mailPath);
            }
            catch (IOException ex) {
                LOGGER.warn("The file could not be deleted: {}", (Object)mailPath, (Object)ex);
            }
        }
    }
}

