/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import de.lwsystems.mailarchive.bennoimport.core.utils.SSLPemParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class BennoRestSslUtils {
    private BennoRestSslUtils() {
    }

    public static KeyStore createJksKeystore(String sslCertPath, String sslPrivateKeyPath, String sslKeyStorePass, String keyStoreAlias) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Objects.requireNonNull(sslCertPath, "sslCertPath in config must not be null");
        Objects.requireNonNull(sslPrivateKeyPath, "sslPrivateKeyPath in config must not be null");
        Certificate[] cert = BennoRestSslUtils.getX509CertificatesFromPemFile(Paths.get(sslCertPath, new String[0]).toFile());
        PrivateKey privateKey = BennoRestSslUtils.getPrivateKeyFromPemFile(Paths.get(sslPrivateKeyPath, new String[0]).toFile());
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null, null);
        keystore.setKeyEntry(keyStoreAlias, privateKey, sslKeyStorePass.toCharArray(), cert);
        return keystore;
    }

    public static PrivateKey getPrivateKeyFromPemFile(File pemFile) throws IOException {
        KeyPair pair = null;
        try (SSLPemParser reader = new SSLPemParser(new FileReader(pemFile));){
            Object pemParser = new SSLPemParser((Reader)((Object)reader)).receiveObject();
            if (pemParser instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)pemParser;
                pair = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
                PrivateKey privateKey = pair.getPrivate();
                return privateKey;
            }
            if (pemParser instanceof PrivateKeyInfo) {
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(PrivateKeyInfo.getInstance((Object)pemParser));
                return privateKey;
            }
        }
        throw new IllegalArgumentException("Could not parse private key");
    }

    public static X509Certificate[] getX509CertificatesFromPemFile(File certificatePem) throws IOException, CertificateException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try (PEMParser pemParser = new PEMParser((Reader)new FileReader(certificatePem));){
            Object pemObject = pemParser.readObject();
            while (pemObject != null) {
                result.add(new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)pemObject));
                pemObject = pemParser.readObject();
            }
        }
        return result.toArray(new X509Certificate[0]);
    }

    public static SslContextFactory createSslContextFactory(boolean isServer, String sslCertPath, String sslPrivateKeyPath, String sslKeyStorePass, String sslKeyStoreType, String keyStoreAlias) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore keystore = BennoRestSslUtils.createJksKeystore(sslCertPath, sslPrivateKeyPath, sslKeyStorePass, keyStoreAlias);
        String keyStoreType = "PKCS12";
        Object sslContextFactory = null;
        sslContextFactory = isServer ? new SslContextFactory.Server() : new SslContextFactory.Client();
        sslContextFactory.setKeyStore(keystore);
        sslContextFactory.setKeyStorePassword(sslKeyStorePass);
        try {
            if (!sslKeyStoreType.isEmpty()) {
                keyStoreType = sslKeyStoreType;
            }
        }
        catch (NullPointerException ex) {
            keyStoreType = "PKCS12";
        }
        sslContextFactory.setKeyStoreType(keyStoreType);
        return sslContextFactory;
    }
}

