/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.FileTypeMap;
import jakarta.activation.URLDataSource;
import jakarta.mail.Message;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.config.EmailProperty;
import org.simplejavamail.internal.util.ImageMimeType;
import org.simplejavamail.internal.util.Preconditions;

public final class MiscUtil {
    private static final Pattern MATCH_INSIDE_CIDBRACKETS = Pattern.compile("<?([^>]*)>?");
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile("(@.*?>?)\\s*[,;]");
    private static final Pattern TRAILING_TOKEN_DELIMITER_PATTERN = Pattern.compile("<\\|>$");
    private static final Pattern TOKEN_DELIMITER_PATTERN = Pattern.compile("\\s*<\\|>\\s*");
    private static final Random RANDOM = new Random();

    public static <T> T checkArgumentNotEmpty(@Nullable T value, @Nullable String msg) {
        if (MiscUtil.valueNullOrEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static <T> boolean valueNullOrEmpty(@Nullable T value) {
        return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof byte[] && ((byte[])value).length == 0;
    }

    @Nullable
    public static <T> T emptyAsNull(@Nullable T value) {
        return MiscUtil.valueNullOrEmpty(value) ? null : (T)value;
    }

    public static String buildLogStringForSOCKSCommunication(byte[] bytes, boolean isReceived) {
        StringBuilder debugMsg = new StringBuilder();
        debugMsg.append(isReceived ? "Received: " : "Sent: ");
        for (byte aByte : bytes) {
            debugMsg.append(Integer.toHexString(MiscUtil.toInt(aByte))).append(" ");
        }
        return debugMsg.toString();
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    @Nullable
    public static String encodeText(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            return MimeUtility.encodeText((String)name, (String)StandardCharsets.UTF_8.name(), (String)"B");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Nullable
    public static String extractCID(@Nullable String cid) {
        return cid != null ? MATCH_INSIDE_CIDBRACKETS.matcher(cid).replaceAll("$1") : null;
    }

    @NotNull
    public static String readInputStreamToString(@NotNull InputStream inputStream, @NotNull Charset charset) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        return byteArrayOutputStream.toString(Preconditions.checkNonEmptyArgument(charset, "charset").name());
    }

    @NotNull
    public static byte[] readInputStreamToBytes(@NotNull InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((read = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, read);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    @NotNull
    public static String[] extractEmailAddresses(@NotNull String emailAddressList) {
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        String unambiguousDelimitedList = COMMA_DELIMITER_PATTERN.matcher(emailAddressList).replaceAll("$1<|>");
        String withoutTrailingDelimeter = TRAILING_TOKEN_DELIMITER_PATTERN.matcher(unambiguousDelimitedList).replaceAll("");
        return TOKEN_DELIMITER_PATTERN.split(withoutTrailingDelimeter, 0);
    }

    @NotNull
    public static Recipient interpretRecipient(@Nullable String name, boolean fixedName, @NotNull String emailAddress, @Nullable Message.RecipientType type) {
        try {
            InternetAddress parsedAddress = InternetAddress.parse((String)emailAddress, (boolean)false)[0];
            String relevantName = fixedName || parsedAddress.getPersonal() == null ? MiscUtil.defaultTo(name, parsedAddress.getPersonal()) : MiscUtil.defaultTo(parsedAddress.getPersonal(), name);
            return new Recipient(relevantName, parsedAddress.getAddress(), type);
        }
        catch (AddressException e) {
            return new Recipient(name, emailAddress, type);
        }
    }

    @Nullable
    public static <T> T defaultTo(@Nullable T value, @Nullable T defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public static boolean classAvailable(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public static <T1, T2> Map.Entry<T1, T2>[] zip(T1[] zipLeft, T2[] zipRight) {
        return MiscUtil.zip(Arrays.asList(zipLeft), Arrays.asList(zipRight)).toArray(new Map.Entry[0]);
    }

    public static <T1, T2> List<Map.Entry<T1, T2>> zip(List<T1> zipLeft, List<T2> zipRight) {
        Preconditions.assumeTrue(zipLeft.size() == zipRight.size(), "Can't zip lists, sizes are not equals");
        ArrayList<Map.Entry<T1, T2>> zipped = new ArrayList<Map.Entry<T1, T2>>();
        for (int i = 0; i < zipLeft.size(); ++i) {
            zipped.add(new AbstractMap.SimpleEntry<T1, T2>(zipLeft.get(i), zipRight.get(i)));
        }
        return zipped;
    }

    @Nullable
    public static String normalizeNewlines(@Nullable String text) {
        return text == null ? null : text.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
    }

    public static int countMandatoryParameters(@NotNull Method m) {
        int mandatoryParameterCount = 0;
        for (Annotation[] annotations : m.getParameterAnnotations()) {
            mandatoryParameterCount += !MiscUtil.containsNullableAnnotation(annotations) ? 1 : 0;
        }
        return mandatoryParameterCount;
    }

    private static boolean containsNullableAnnotation(Annotation[] annotations) {
        for (Annotation annotation : (Annotation[])annotations.clone()) {
            if (annotation.annotationType() != Nullable.class) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static DataSource tryResolveImageFileDataSourceFromDisk(@Nullable String baseDir, boolean allowOutsideBaseDir, @NotNull String srcLocation) {
        DataSource dataSource;
        if (baseDir == null) {
            dataSource = MiscUtil.tryLoadingFromDisk(new File(srcLocation));
            if (dataSource == null) {
                dataSource = MiscUtil.tryLoadingFromDisk(new File(".", srcLocation));
            }
        } else if (srcLocation.startsWith(baseDir)) {
            dataSource = MiscUtil.tryLoadingFromDisk(new File(srcLocation));
        } else {
            dataSource = MiscUtil.tryLoadingFromDisk(new File(baseDir, srcLocation));
            if (dataSource == null && allowOutsideBaseDir && (dataSource = MiscUtil.tryLoadingFromDisk(new File(".", srcLocation))) == null) {
                dataSource = MiscUtil.tryLoadingFromDisk(new File(srcLocation));
            }
        }
        return dataSource;
    }

    @Nullable
    public static DataSource tryResolveFileDataSourceFromClassPath(@Nullable String baseClassPath, boolean allowOutsideBaseClassPath, @NotNull String srcLocation) throws IOException {
        DataSource dataSource;
        if (baseClassPath == null) {
            dataSource = MiscUtil.tryLoadingFromClassPath(srcLocation);
        } else if (srcLocation.startsWith(baseClassPath)) {
            dataSource = MiscUtil.tryLoadingFromClassPath(srcLocation);
        } else {
            dataSource = MiscUtil.tryLoadingFromClassPath(baseClassPath + srcLocation);
            if (dataSource == null && allowOutsideBaseClassPath) {
                dataSource = MiscUtil.tryLoadingFromClassPath(srcLocation);
            }
        }
        return dataSource;
    }

    @Nullable
    public static DataSource tryResolveUrlDataSource(@Nullable URL baseUrl, boolean allowOutsideBaseUrl, @NotNull String srcLocation) throws IOException {
        DataSource dataSource;
        if (baseUrl == null) {
            dataSource = MiscUtil.tryLoadingFromUrl(srcLocation);
        } else if (MiscUtil.isCorrectlyFormattedUrl(srcLocation) && new URL(srcLocation).getPath().startsWith(baseUrl.getPath())) {
            dataSource = MiscUtil.tryLoadingFromUrl(srcLocation);
        } else {
            String urlPath = (baseUrl.getAuthority() + baseUrl.getPath() + "/" + srcLocation).replaceAll("/\\\\", "/").replaceAll("//", "/");
            String url = String.format("%s://%s", baseUrl.getProtocol(), urlPath);
            dataSource = MiscUtil.tryLoadingFromUrl(url);
            if (dataSource == null && allowOutsideBaseUrl) {
                dataSource = MiscUtil.tryLoadingFromUrl(srcLocation);
            }
        }
        return dataSource;
    }

    @Nullable
    private static DataSource tryLoadingFromDisk(@NotNull File srcLocation) {
        if (srcLocation.exists()) {
            FileDataSource fileDataSource = new FileDataSource(srcLocation);
            fileDataSource.setFileTypeMap((FileTypeMap)ImageMimeType.IMAGE_MIMETYPES_FILE_TYPE_MAP);
            return fileDataSource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static DataSource tryLoadingFromClassPath(@NotNull String resourceName) throws IOException {
        String cleanResourceName = resourceName.replaceAll("//", "/");
        InputStream is = MiscUtil.class.getResourceAsStream(cleanResourceName);
        if (is != null) {
            try {
                String mimeType = ImageMimeType.getContentType(resourceName);
                ByteArrayDataSource ds = new ByteArrayDataSource(is, mimeType);
                ds.setName(MiscUtil.class.getResource(cleanResourceName).toString());
                ByteArrayDataSource byteArrayDataSource = ds;
                return byteArrayDataSource;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    @Nullable
    private static DataSource tryLoadingFromUrl(String url) {
        try {
            URLDataSource result = new URLDataSource(new URL(url));
            result.getInputStream();
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isCorrectlyFormattedUrl(String srcLocation) {
        try {
            new URL(srcLocation);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String randomCid10() {
        int start = 32;
        int end = 123;
        int gap = 91;
        StringBuilder buffer = new StringBuilder();
        while (buffer.length() < 10) {
            char ch = (char)(RANDOM.nextInt(91) + 32);
            if (!Character.isLetter(ch)) continue;
            buffer.append(ch);
        }
        return buffer.toString().toLowerCase();
    }

    @NotNull
    public static String parseBaseMimeType(@NotNull String fullMimeType) {
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }

    @Nullable
    public static <Out> Out overrideOrProvideOrDefaultProperty(@Nullable Email provided, @Nullable Email defaults, @Nullable Email overrides, @NotNull EmailProperty emailProperty) {
        return Optional.ofNullable(MiscUtil.overrideAllowedForProperty(provided, emailProperty) ? overrides : null).map(emailProperty.getGetter()).orElse(Optional.ofNullable(provided).map(emailProperty.getGetter()).orElse(Optional.ofNullable(MiscUtil.defaultAllowedForProperty(provided, emailProperty) ? defaults : null).map(emailProperty.getGetter()).orElse(null)));
    }

    @NotNull
    public static <Out> List<Out> overrideAndOrProvideAndOrDefaultCollection(@Nullable Email provided, @Nullable Email defaults, @Nullable Email overrides, @NotNull EmailProperty emailProperty) {
        ArrayList listOut = new ArrayList();
        if (overrides != null && MiscUtil.overrideAllowedForProperty(provided, emailProperty)) {
            listOut.addAll((Collection)emailProperty.getGetter().apply(overrides));
        }
        if (provided != null) {
            listOut.addAll((Collection)emailProperty.getGetter().apply(provided));
        }
        if (defaults != null && MiscUtil.defaultAllowedForProperty(provided, emailProperty)) {
            listOut.addAll((Collection)emailProperty.getGetter().apply(defaults));
        }
        return listOut;
    }

    @NotNull
    public static Map<String, Collection<String>> overrideAndOrProvideAndOrDefaultHeaders(@Nullable Email provided, @Nullable Email defaults, @Nullable Email overrides) {
        HashMap<String, Collection<String>> collectedHeaders = new HashMap<String, Collection<String>>();
        if (defaults != null && MiscUtil.defaultAllowedForProperty(provided, EmailProperty.HEADERS)) {
            MiscUtil.addOrOverrideHeaders(collectedHeaders, defaults.getHeaders());
        }
        if (provided != null) {
            MiscUtil.addOrOverrideHeaders(collectedHeaders, provided.getHeaders());
        }
        if (overrides != null && MiscUtil.overrideAllowedForProperty(provided, EmailProperty.HEADERS)) {
            MiscUtil.addOrOverrideHeaders(collectedHeaders, overrides.getHeaders());
        }
        return collectedHeaders;
    }

    private static boolean defaultAllowedForProperty(@Nullable Email provided, @NotNull EmailProperty emailProperty) {
        return provided == null || !provided.isIgnoreDefaults() && (provided.getPropertiesNotToApplyDefaultValueFor() == null || !provided.getPropertiesNotToApplyDefaultValueFor().contains((Object)emailProperty));
    }

    private static boolean overrideAllowedForProperty(@Nullable Email provided, @NotNull EmailProperty emailProperty) {
        return provided == null || !provided.isIgnoreOverrides() && (provided.getPropertiesNotToApplyOverrideValueFor() == null || !provided.getPropertiesNotToApplyOverrideValueFor().contains((Object)emailProperty));
    }

    private static void addOrOverrideHeaders(HashMap<String, Collection<String>> collectedHeaders, @NotNull Map<String, Collection<String>> headers) {
        headers.forEach((headerKey, headerValues) -> {
            collectedHeaders.putIfAbsent((String)headerKey, new ArrayList());
            ((Collection)collectedHeaders.get(headerKey)).clear();
            ((Collection)collectedHeaders.get(headerKey)).addAll(headerValues);
        });
    }

    public static void assignToInstanceField(Object subject, String fieldName, Object newValue) {
        Field field = subject.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(subject, newValue);
    }

    @NotNull
    public static List<InternetAddress> asInternetAddresses(@NotNull List<Recipient> recipient, @NotNull Charset charset) {
        return recipient.stream().map(r -> MiscUtil.asInternetAddress(r, charset)).collect(Collectors.toList());
    }

    @NotNull
    public static InternetAddress asInternetAddress(@NotNull Recipient recipient, @NotNull Charset charset) {
        return new InternetAddress(recipient.getAddress(), recipient.getName(), charset.name());
    }

    @NotNull
    public static Optional<String> findFirstMatch(@NotNull Pattern pattern, @NotNull String input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }
}

