/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.models;

import java.util.ArrayList;
import java.util.List;

public class Container {
    StringBuilder containerFileName = new StringBuilder();
    StringBuilder header = new StringBuilder();
    List<String> containerBlackList = new ArrayList<String>();
    List<String> containers = new ArrayList<String>();

    public Container(List<String> containerBlackList, List<String> containers, String headerName) {
        this.containerBlackList = containerBlackList;
        this.containers = containers;
        this.removeBlacklistedContainers();
        if (!this.containers.isEmpty()) {
            for (String container : containers) {
                this.appendFileName(container);
                this.appendHeader(headerName, container);
            }
            this.containerFileName.replace(this.containerFileName.length() - 1, this.containerFileName.length(), "");
        }
    }

    private void removeBlacklistedContainers() {
        for (String container : this.containerBlackList) {
            this.containers.removeIf(x -> x.equalsIgnoreCase(container));
        }
    }

    private void appendFileName(String container) {
        this.containerFileName.append(container).append(":");
    }

    private void appendHeader(String headerName, String container) {
        this.header.append(headerName).append(": ").append(container).append("\r\n");
    }

    public List<String> getContainers() {
        return this.containers;
    }

    public StringBuilder getHeader() {
        return this.header;
    }

    public StringBuilder getContainerFileName() {
        return this.containerFileName;
    }
}

