/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.utils;

import de.lwsystems.mailarchive.bennoimport.core.utils.Headers;
import de.lwsystems.mailarchive.bennoimport.core.utils.JwtUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class BennoHeaderUtils {
    private BennoHeaderUtils() {
    }

    public static Map<String, String> setBennoGwHeaderToMailHeaders(Map<String, String> mailHeaders, String[] bennoGwHeaders) {
        HashMap<String, String> headerMap = new HashMap<String, String>(mailHeaders);
        headerMap.put(Headers.BENNOGW.getValue(), BennoHeaderUtils.arrayToHttpHeaderValue(bennoGwHeaders));
        return headerMap;
    }

    public static String arrayToHttpHeaderValue(String[] array) {
        return Arrays.stream(array).map(BennoHeaderUtils::escapeAndQuoteIfNeeded).collect(Collectors.joining(", "));
    }

    private static String escapeAndQuoteIfNeeded(String value) {
        if (value.contains(",") || value.contains("\"") || value.contains("\\")) {
            return "\"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        return value;
    }

    public static String createBasicAuthString(String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        return "Basic " + authStringEnc;
    }

    public static String createBearerToken(String tokenValue) {
        return "Bearer " + tokenValue;
    }

    public static Map<String, String> createBearerTokenHeader(String tokenValue) {
        return Map.of(Headers.AUTHORIZATION.getValue(), BennoHeaderUtils.createBearerToken(tokenValue));
    }

    public static Map<String, String> createBasicAuthHeader(String username, String password) {
        return Map.of(Headers.AUTHORIZATION.getValue(), BennoHeaderUtils.createBasicAuthString(username, password));
    }

    public static Map<String, String> createBasicAuthHeader(String basicAuthString) {
        return Map.of(Headers.AUTHORIZATION.getValue(), basicAuthString);
    }

    public static String getTokenFromBearerAuth(String bearerAuth) {
        return bearerAuth.split(" ")[1];
    }

    public static void createBearerTokenHeader(String mailChecksum, Map<String, String> mailHeaders, String sharedSecret, long expirationMinutes) {
        String token = JwtUtil.generateJwtToken(mailChecksum, sharedSecret, expirationMinutes);
        mailHeaders.clear();
        mailHeaders.put(Headers.AUTHORIZATION.getValue(), BennoHeaderUtils.createBearerTokenHeader(token).get(Headers.AUTHORIZATION.getValue()));
    }
}

