/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services.msjournal;

import de.lwsystems.mailarchive.bennoimport.core.models.MicrosoftJournalingMail;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IMicrosoftJournalMailParser;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicrosoftJournalMailTextParser
implements IMicrosoftJournalMailParser {
    private static final Logger LOGGER = LogManager.getLogger(MicrosoftJournalMailTextParser.class);
    private final MicrosoftJournalingMail microsoftJournalingMail = new MicrosoftJournalingMail();
    private static final Pattern RECIPIENT_PATTERN = Pattern.compile("^(Recipient|To|Cc|Bcc)$", 2);
    private static final Pattern SENDER_PATTERN_URL_ENCODED = Pattern.compile("^(=EF=BB=BF)?Sender$", 2);
    private static final Pattern SENDER_PATTERN_RAW_BOM = Pattern.compile("^\ufeff?Sender$", 2);
    private static final Pattern ON_BEHALF_OF_PATTERN_URL_ENCODED = Pattern.compile("^(=EF=BB=BF)?On-Behalf-Of$", 2);
    private static final Pattern ON_BEHALF_OF_PATTERN_RAW_BOM = Pattern.compile("^\ufeff?On-Behalf-Of$", 2);
    private static final Pattern SMTP_PREFIX_PATTERN = Pattern.compile("^<smtp:", 2);

    @Override
    public void parseTextContent(String textContent) {
        this.microsoftJournalingMail.clear();
        LOGGER.trace("Processing {} lines of text content", (Object)textContent.lines().count());
        textContent.lines().forEach(output -> {
            String value;
            String content = output.replaceAll("[\\r\\n]", "");
            LOGGER.trace("Processing line: {}", (Object)content);
            String[] headerValue = content.split(":\\s+", 2);
            String header = headerValue[0];
            String string = value = headerValue.length > 1 ? headerValue[1] : "";
            if (RECIPIENT_PATTERN.matcher(header).matches()) {
                LOGGER.debug("Found recipient header: {}", (Object)header);
                this.recipientHandler(value);
                return;
            }
            this.senderHandler(header, value);
        });
    }

    @Override
    public MicrosoftJournalingMail getParsedMailData() {
        LOGGER.debug("Returning parsed mail data");
        return this.microsoftJournalingMail;
    }

    private void senderHandler(String header, String value) {
        String senderData = "";
        String onBehalfData = "";
        String sender = "";
        if (SENDER_PATTERN_URL_ENCODED.matcher(header).matches() || SENDER_PATTERN_RAW_BOM.matcher(header).matches() || header.equalsIgnoreCase("\ufeffSender")) {
            LOGGER.debug("Found sender header with value: {}", (Object)value);
            senderData = value;
        }
        if (ON_BEHALF_OF_PATTERN_URL_ENCODED.matcher(header).matches() || ON_BEHALF_OF_PATTERN_RAW_BOM.matcher(header).matches() || header.equalsIgnoreCase("On-Behalf-Of")) {
            LOGGER.debug("Found on-behalf-of header with value: {}", (Object)value);
            onBehalfData = value;
        }
        if (onBehalfData.isEmpty() && senderData.isEmpty()) {
            return;
        }
        if (!onBehalfData.isEmpty()) {
            LOGGER.debug("Using on-behalf-of value as sender: {}", (Object)onBehalfData);
            sender = onBehalfData;
        } else {
            LOGGER.debug("Using sender value: {}", (Object)senderData);
            sender = senderData;
        }
        if (sender.contains("@")) {
            this.microsoftJournalingMail.setSender(SMTP_PREFIX_PATTERN.matcher(sender).replaceAll("<"));
        } else {
            this.microsoftJournalingMail.setSender(sender);
        }
    }

    private void recipientHandler(String value) {
        String[] tokens;
        LOGGER.debug("Processing recipient value: {}", (Object)value);
        for (String token : tokens = value.split(",?\\s+")) {
            if (token.matches("(?i)Expanded:") || token.matches("(?i)Forwarded:")) {
                LOGGER.debug("Skipping special token: {}", (Object)token);
                continue;
            }
            LOGGER.trace("Adding recipient: {}", (Object)token);
            this.microsoftJournalingMail.addRecipient(token);
        }
    }
}

