/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.core.services.msjournal;

import de.lwsystems.mailarchive.bennoimport.core.services.IMailPartHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IMicrosoftJournalMailParser;
import de.lwsystems.mailarchive.bennoimport.core.utils.IContentDecoder;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextPlainMailPartHandler
implements IMailPartHandler {
    private static final Logger LOGGER = LogManager.getLogger(TextPlainMailPartHandler.class);
    private final IMicrosoftJournalMailParser parser;
    private final IContentDecoder contentDecoder;

    public TextPlainMailPartHandler(IMicrosoftJournalMailParser parser, IContentDecoder contentDecoder) {
        this.parser = parser;
        this.contentDecoder = contentDecoder;
    }

    @Override
    public boolean canHandle(BodyPart bodyPart) throws MessagingException {
        return bodyPart.isMimeType("text/plain");
    }

    @Override
    public void handle(BodyPart bodyPart) throws MessagingException, IOException {
        String contentString = bodyPart.getContent().toString();
        try {
            contentString = this.contentDecoder.decode(contentString);
        }
        catch (IllegalArgumentException ex) {
            contentString = bodyPart.getContent().toString();
        }
        this.parser.parseTextContent(contentString);
    }
}

