/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.subethamail.smtp.internal.io.Utf8InputStreamReader;

public final class CRLFTerminatedReader
extends Reader {
    private static final int MAX_LINE_LENGTH = 998;
    private final Reader in;
    private final StringBuffer lineBuffer = new StringBuffer();
    private static final int EOF = -1;
    private static final int CR = 13;
    private static final int LF = 10;
    private int tainted = -1;

    public CRLFTerminatedReader(InputStream in) {
        this.in = new Utf8InputStreamReader(in);
    }

    public String readLine() throws IOException {
        this.lineBuffer.delete(0, this.lineBuffer.length());
        boolean cr_just_received = false;
        do {
            int inChar = this.read();
            if (!cr_just_received) {
                switch (inChar) {
                    case 13: {
                        cr_just_received = true;
                        break;
                    }
                    case -1: {
                        return null;
                    }
                    case 10: {
                        if (this.tainted == -1) {
                            this.tainted = this.lineBuffer.length();
                        }
                    }
                    default: {
                        this.lineBuffer.append((char)inChar);
                        break;
                    }
                }
                continue;
            }
            switch (inChar) {
                case 10: {
                    if (this.tainted != -1) {
                        int pos = this.tainted;
                        this.tainted = -1;
                        throw new TerminationException("\"bare\" CR or LF in data stream", pos);
                    }
                    return this.lineBuffer.toString();
                }
                case -1: {
                    return null;
                }
                case 13: {
                    if (this.tainted == -1) {
                        this.tainted = this.lineBuffer.length();
                    }
                    this.lineBuffer.append('\r');
                    break;
                }
                default: {
                    if (this.tainted == -1) {
                        this.tainted = this.lineBuffer.length();
                    }
                    this.lineBuffer.append('\r');
                    this.lineBuffer.append((char)inChar);
                    cr_just_received = false;
                }
            }
        } while (this.lineBuffer.length() < 998);
        throw new MaxLineLengthException("Input line length is too long!");
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.ready();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        char[] temp = new char[len];
        int result = this.in.read(temp, 0, len);
        for (int i = 0; i < result; ++i) {
            cbuf[i] = temp[i];
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static final class MaxLineLengthException
    extends IOException {
        public MaxLineLengthException() {
        }

        public MaxLineLengthException(String s) {
            super(s);
        }
    }

    public static final class TerminationException
    extends IOException {
        private int where;

        public TerminationException(int where) {
            this.where = where;
        }

        public TerminationException(String s, int where) {
            super(s);
            this.where = where;
        }

        public int position() {
            return this.where;
        }
    }
}

