/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import com.github.davidmoten.guavamini.Preconditions;
import org.subethamail.smtp.internal.server.AcceptAllSessionHandler;
import org.subethamail.smtp.internal.server.ConcurrentSessionsBySourceLimiter;
import org.subethamail.smtp.server.Session;

public interface SessionHandler {
    public SessionAcceptance accept(Session var1);

    public void onSessionEnd(Session var1);

    public static SessionHandler limitConcurrentSessionsBySource(int maxConnectionsPerSource) {
        return new ConcurrentSessionsBySourceLimiter(maxConnectionsPerSource);
    }

    public static SessionHandler acceptAll() {
        return AcceptAllSessionHandler.INSTANCE;
    }

    public static final class SessionAcceptance {
        private static final SessionAcceptance SUCCESS = new SessionAcceptance(true, 0, null);
        private final boolean accepted;
        private final int errorCode;
        private final String errorMessage;

        public static SessionAcceptance success() {
            return SUCCESS;
        }

        public static SessionAcceptance failure(int code, String message) {
            return new SessionAcceptance(false, code, message);
        }

        SessionAcceptance(boolean accepted, int errorCode, String errorMessage) {
            Preconditions.checkArgument((accepted || errorCode > 199 && errorCode < 600 ? 1 : 0) != 0, (String)("Invalid SMTP response code " + errorCode));
            Preconditions.checkArgument((!accepted || errorCode == 0 && errorMessage == null ? 1 : 0) != 0);
            this.accepted = accepted;
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public boolean accepted() {
            return this.accepted;
        }

        public int errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }
    }
}

