/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest;

import de.lwsystems.mailarchive.importrest.JettyServer;
import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.SecureRequestCustomizer;

public class Main {
    private static final Logger LOGGER = LogManager.getLogger(Main.class);
    private static JettyServer server;

    public static void main(String[] args) {
        Main.setConfigFromCommandLine(args);
        Main.configureServer();
        Main.startServer();
    }

    private static void setConfigFromCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(Option.builder("c").argName("CONFIG").longOpt("configuration file").desc("Add a configuration file").hasArg().type(String.class).build());
        try {
            CommandLine cmdl = parser.parse(options, args, true);
            if (!cmdl.hasOption("c")) {
                throw new FileNotFoundException("No configuration file was set in command line");
            }
            LOGGER.debug("Load configuration file from {}", (Object)cmdl.getOptionValue("c"));
            ConfigurationHandler.getInstance(Paths.get(cmdl.getOptionValue("c"), new String[0]).toAbsolutePath());
        }
        catch (ParseException ex) {
            LOGGER.error("Error while parsing command line arguments", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error while loading configuration file", (Throwable)ex);
        }
    }

    private static HttpConfiguration getHttpsConfiguration(int port) {
        HttpConfiguration config = new HttpConfiguration();
        config.setSecureScheme("https");
        config.setSecurePort(port);
        config.setSendXPoweredBy(true);
        config.setSendServerVersion(true);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        config.addCustomizer(src);
        return config;
    }

    private static void configureServer() {
        try {
            URI baseUri = UriBuilder.fromUri(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getHostUri()).port(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getPort()).build(new Object[0]);
            server = new JettyServer();
            String host = "";
            if (ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getHostUri().toLowerCase().matches("^https?://.*")) {
                host = ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getHostUri().substring(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getHostUri().indexOf("://") + 3);
            }
            if (ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getHostUri().matches("^https://.*")) {
                server.configureHttpsServer(host, ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getPort());
            } else {
                server.configureHttpServer(host, ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getPort());
            }
            LOGGER.info("Start Benno Rest Import service on following address: {}", (Object)baseUri);
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("File not found: {}", (Object)ex.getMessage());
            System.exit(1);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            LOGGER.error("Error while loading SSL Keystore: {}", (Object)ex.getMessage());
            System.exit(1);
        }
    }

    private static void startServer() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                server.stopServer();
            }
            catch (Exception ex) {
                LOGGER.error("Error while stopping server: {}", (Object)ex.getMessage());
                System.exit(1);
            }
        }));
        try {
            server.startServer();
        }
        catch (Exception ex) {
            LOGGER.error("Error while starting server: {}", (Object)ex.getMessage());
            System.exit(1);
        }
    }
}

