/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.lwsystems.mailarchive.importrest.config.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.importrest.config.authorization.UploadResponse;
import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import de.lwsystems.mailarchive.importrest.utils.BennoRestImportUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.server.Request;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class AuthorizationRequestFilter
implements Filter {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationRequestFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AuthorizationResponse authorizationResponse;
        UploadResponse uploadResponse;
        HttpClient client;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setContentType("application/json; charset=UTF-8");
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Basic")) {
            LOGGER.error("No auth header was found");
            UploadResponse uploadResponse2 = new UploadResponse("No auth header was found", 401);
            response.setStatus(uploadResponse2.getStatus());
            response.getWriter().write(mapper.writeValueAsString(uploadResponse2));
            return;
        }
        try {
            client = BennoRestImportUtils.clientBuilder(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getAuthorizationUrl());
        }
        catch (Exception ex) {
            LOGGER.error("Error while creating client");
            UploadResponse uploadResponse3 = new UploadResponse("Error while creating client", 500);
            response.setStatus(uploadResponse3.getStatus());
            response.getWriter().write(mapper.writeValueAsString(uploadResponse3));
            return;
        }
        String authResponse = "";
        String authorizationUrl = ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getAuthorizationUrl();
        String authUser = BennoRestImportUtils.userFromAuthHeader(authHeader);
        try {
            ContentResponse contentResponse = client.newRequest(authorizationUrl).method("GET").headers(headers -> headers.add("Authorization", authHeader)).send();
            HttpContentResponse httpContentResponse = (HttpContentResponse)contentResponse;
            authResponse = httpContentResponse.getContentAsString();
            if (httpContentResponse.getStatus() == 200) {
                LOGGER.debug("Login to {} as {} was successful", (Object)authorizationUrl, (Object)authUser);
            } else {
                if (httpContentResponse.getStatus() == 401) {
                    LOGGER.error("Authorization error {} as {}", (Object)authorizationUrl, (Object)authUser);
                    UploadResponse uploadResponse4 = new UploadResponse("Authorization error", 401);
                    response.setStatus(uploadResponse4.getStatus());
                    response.getWriter().write(mapper.writeValueAsString(uploadResponse4));
                    return;
                }
                if (httpContentResponse.getStatus() == 403) {
                    LOGGER.error("Login to {} as {} was not successful: " + httpContentResponse.getStatus() + " httpContentResponse.getStatusInfo()", (Object)authorizationUrl, (Object)authUser);
                    UploadResponse uploadResponse5 = new UploadResponse("Login to " + authorizationUrl + " was not successful", 403);
                    response.setStatus(uploadResponse5.getStatus());
                    response.getWriter().write(mapper.writeValueAsString(uploadResponse5));
                    return;
                }
                if (httpContentResponse.getStatus() == 404) {
                    LOGGER.error("REST endpoint not found {}", (Object)authorizationUrl);
                    UploadResponse uploadResponse6 = new UploadResponse("REST endpoint not found", 404);
                    response.setStatus(uploadResponse6.getStatus());
                    response.getWriter().write(mapper.writeValueAsString(uploadResponse6));
                    return;
                }
                if (httpContentResponse.getStatus() == 500) {
                    LOGGER.error("Error while connecting to {}: " + httpContentResponse.getStatus(), (Object)authorizationUrl);
                    UploadResponse uploadResponse7 = new UploadResponse("Error while connecting to " + authorizationUrl, 500);
                    response.setStatus(uploadResponse7.getStatus());
                    response.getWriter().write(mapper.writeValueAsString(uploadResponse7));
                    return;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while connecting to {}: 500 " + ex.getMessage(), (Object)authorizationUrl);
            uploadResponse = new UploadResponse(ex.getMessage(), 500);
            response.setStatus(uploadResponse.getStatus());
            response.getWriter().write(mapper.writeValueAsString(uploadResponse));
            return;
        }
        finally {
            try {
                client.stop();
            }
            catch (Exception e) {
                LOGGER.warn("Error while stopping client");
            }
        }
        try {
            Yaml yaml = new Yaml(new Constructor(AuthorizationResponse.class));
            authorizationResponse = (AuthorizationResponse)yaml.load(authResponse);
        }
        catch (Exception ex) {
            LOGGER.error("Error while parsing response: " + ex.getMessage());
            UploadResponse uploadResponse8 = new UploadResponse("Error while parsing response: " + ex.getMessage(), 500);
            response.setStatus(uploadResponse8.getStatus());
            response.getWriter().write(mapper.writeValueAsString(uploadResponse8));
            return;
        }
        ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().setBaseUri(this.setBaseUri((Request)request));
        if (authResponse.equals("")) {
            LOGGER.error("Authorization Response object is null");
            uploadResponse = new UploadResponse("Error while parsing response", 500);
            response.setStatus(uploadResponse.getStatus());
            response.getWriter().write(mapper.writeValueAsString(uploadResponse));
            return;
        }
        request.setAttribute("response", authorizationResponse);
        request.setAttribute("authorization", authHeader);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String setBaseUri(Request request) {
        StringBuilder baseUri = new StringBuilder().append(request.getHttpURI().getHost());
        if (request.getHttpURI().getPort() > 0) {
            baseUri.append(":").append(request.getHttpURI().getPort());
        }
        return baseUri.toString();
    }
}

