/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.services;

import de.lwsystems.mailarchive.importrest.config.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.importrest.config.authorization.UploadResponse;
import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import de.lwsystems.mailarchive.importrest.models.Container;
import de.lwsystems.mailarchive.importrest.models.Mail;
import de.lwsystems.mailarchive.importrest.services.ReadMail;
import de.lwsystems.mailarchive.importrest.services.UploadMail;
import de.lwsystems.mailarchive.importrest.services.WriteMail;
import de.lwsystems.mailarchive.importrest.utils.BennoRestImportUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailHandling {
    private static final Logger LOGGER = LogManager.getLogger(MailHandling.class);
    private AuthorizationResponse authorizationResponse;
    private String authHeader;

    public MailHandling(AuthorizationResponse authorizationResponse, String authHeader) {
        this.authorizationResponse = authorizationResponse;
        this.authHeader = authHeader;
    }

    public UploadResponse processMail(InputStream uploadedInputStream) throws Exception {
        String checksum = "";
        boolean mailProcessed = false;
        try {
            Object uploadResponse2;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            uploadedInputStream.transferTo(baos);
            ByteArrayInputStream mailUploadStream = new ByteArrayInputStream(baos.toByteArray());
            Mail mail = this.readMail(mailUploadStream);
            if (mail == null) {
                UploadResponse uploadResponse2 = new UploadResponse("Sent mail is empty", 500);
                return uploadResponse2;
            }
            checksum = BennoRestImportUtils.calculateMailChecksum(mail.getRawMail());
            for (Map.Entry<String, String[]> url : this.authorizationResponse.getData().getStorageurls().entrySet()) {
                if (url.getKey().toLowerCase().matches("^https?://.*") && !url.getKey().toLowerCase().contains(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getBaseUri().toLowerCase())) {
                    this.uploadMail(url.getKey(), baos, checksum, this.authHeader);
                    mailProcessed = true;
                    continue;
                }
                if (!url.getKey().matches("^file://.*") && !url.getKey().toLowerCase().contains(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getBaseUri().toLowerCase())) continue;
                String address = "";
                address = url.getKey().toLowerCase().contains(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getBaseUri().toLowerCase()) ? ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getStandardPath() : url.getKey().replace("file://", "");
                String[] containers = url.getValue();
                if (containers.length == 0) {
                    LOGGER.error("No containers set for: {}" + address);
                    continue;
                }
                if (containers.length == 1 && containers[0].isEmpty()) {
                    LOGGER.error("No containers set for: {}" + address);
                    continue;
                }
                Container container = new Container(new ArrayList<String>(Arrays.asList(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getContainerBlacklist())), new ArrayList<String>(Arrays.asList(containers)), ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getHeader());
                mail.setBennoGwHeaders(container.getHeader());
                String fileName = BennoRestImportUtils.setFilename(checksum, container.getContainerFileName().toString(), 0);
                int counter = 0;
                while (Files.exists(new File(address + File.separator + fileName + ".eml").toPath(), new LinkOption[0]) && counter < 1000) {
                    fileName = BennoRestImportUtils.setFilename(checksum, container.getContainerFileName().toString(), ++counter);
                }
                this.saveMail(address, mail, fileName, ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getWaitTime());
                mailProcessed = true;
            }
            if (!mailProcessed) {
                LOGGER.error("Mail: {} was not processed. Check that the StorageUrl object from the authorization uri is not empty.", (Object)checksum);
                uploadResponse2 = new UploadResponse(checksum, "Mail: " + checksum + "was not processed. Check that the StorageUrl object from the authorization uri is not empty.", 500);
                return uploadResponse2;
            }
            uploadResponse2 = new UploadResponse(checksum, "Mail import was successful", 200);
            return uploadResponse2;
        }
        catch (Exception ex) {
            UploadResponse uploadResponse = new UploadResponse(checksum, ex.getMessage(), 500);
            return uploadResponse;
        }
    }

    private Mail readMail(InputStream mailUploadStream) throws IOException {
        ReadMail readMail = new ReadMail();
        return readMail.convertInputStreamToMail(mailUploadStream);
    }

    private void uploadMail(String url, ByteArrayOutputStream baos, String checksum, String authHeader) throws Exception {
        ByteArrayInputStream tmpMailStream = new ByteArrayInputStream(baos.toByteArray());
        UploadMail uploadMail = new UploadMail();
        uploadMail.uploadMail(tmpMailStream, url, authHeader, checksum);
    }

    private void saveMail(String address, Mail mail, String fileName, int waitTime) throws IOException, InterruptedException {
        WriteMail writeMail = new WriteMail();
        writeMail.saveMail(address, mail, fileName, waitTime);
    }
}

