/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.services;

import de.lwsystems.mailarchive.importrest.models.Mail;
import de.lwsystems.mailarchive.importrest.utils.BennoRestImportUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WriteMail {
    private static final Logger LOGGER = LogManager.getLogger(WriteMail.class);

    public void saveMail(String address, Mail mail, String fileName, int waitTime) throws InterruptedException, IOException {
        Path tmpMail = new File(address + File.separator + fileName + ".tmp").toPath();
        Path emlMail = new File(address + File.separator + fileName + ".eml").toPath();
        try {
            int savingMailWaitTime = BennoRestImportUtils.determineWaitTime(address, waitTime);
            LOGGER.debug("Wait {} seconds before saving the mail", (Object)TimeUnit.MILLISECONDS.toMinutes(savingMailWaitTime));
            Thread.sleep(savingMailWaitTime);
            this.writeMailToFilesystem(mail, address + "/" + fileName + ".tmp");
            LOGGER.debug("Copy temp file to eml from {} to {}", (Object)tmpMail.toAbsolutePath(), (Object)emlMail.toAbsolutePath());
            Files.copy(tmpMail, emlMail, StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Imported email saved as {}", (Object)emlMail.toAbsolutePath());
        }
        catch (Exception ex) {
            LOGGER.error("Cannot write email to {}: {}", (Object)(address + File.separator), (Object)ex.getStackTrace());
            throw new IOException("Cannot save email with checksum " + fileName);
        }
        finally {
            if (Files.exists(tmpMail.toAbsolutePath(), new LinkOption[0])) {
                LOGGER.debug("Delete temp file {} ", (Object)tmpMail.toAbsolutePath());
                Files.delete(tmpMail);
            }
        }
    }

    private void writeMailToFilesystem(Mail mail, String inbox) throws IOException {
        LOGGER.trace("Start writing mail to {}", (Object)inbox);
        FileOutputStream mailOutput = new FileOutputStream(inbox);
        BufferedOutputStream bufferedOutputStream = this.setMailToBufferedOutputStream(mail, mailOutput);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        LOGGER.debug("Temp file was written to {}", (Object)inbox);
    }

    private BufferedOutputStream setMailToBufferedOutputStream(Mail mail, FileOutputStream mailOutput) throws IOException {
        BufferedOutputStream mailStream = new BufferedOutputStream(mailOutput);
        mailStream.write(mail.getBennoGwHeader().toString().getBytes());
        LOGGER.trace("Add GW header to mail output");
        mailStream.write(mail.getSecretHeaders().toByteArray());
        LOGGER.trace("Add secret header to mail output");
        mailStream.write(mail.getRawMail().toByteArray());
        LOGGER.trace("Add raw mail to mail output");
        return mailStream;
    }
}

