/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.utils;

import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class BennoRestImportUtils {
    static FileFilter emlFileFilter = file -> file.getName().endsWith(".eml");
    private static final Pattern CHECKSUM_RESPONSE = Pattern.compile("\\b[0-9A-F]{30,}\\b$");

    private BennoRestImportUtils() {
    }

    public static String calculateMailChecksum(ByteArrayOutputStream outputStream) throws IllegalArgumentException {
        Objects.requireNonNull(outputStream, "outputStream must not be null");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(outputStream.toByteArray());
            return BennoRestImportUtils.fromBytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 hashing algorithm unknown in this VM.", e);
        }
    }

    private static String fromBytesToHex(byte[] bytes) {
        String hexString = bytes == null ? "" : new String(Hex.encodeHex(bytes, false));
        return hexString;
    }

    public static String userFromAuthHeader(String authHeader) {
        String headerValue = authHeader.split(" ")[1];
        String authUser = new String(Base64.getDecoder().decode(headerValue)).split(":")[0];
        return authUser;
    }

    public static String setFilename(String checksum, String containerName, int sequenceNumber) {
        int FILE_LENGTH = 250;
        Object fileName = containerName.length() > 0 ? checksum + "-" + BennoRestImportUtils.sequenceNumber(sequenceNumber) + ":" + containerName : checksum + "-" + BennoRestImportUtils.sequenceNumber(sequenceNumber);
        if (((String)fileName).length() > 250) {
            fileName = ((String)fileName).substring(0, 250);
        }
        return fileName;
    }

    private static String sequenceNumber(int sequenceNumber) {
        if (sequenceNumber == 0) {
            return "000";
        }
        if (sequenceNumber > 0 && sequenceNumber < 10) {
            return "00" + sequenceNumber;
        }
        if (sequenceNumber >= 10 && sequenceNumber < 100) {
            return "0" + sequenceNumber;
        }
        if (sequenceNumber >= 100 && sequenceNumber < 1000) {
            return Integer.toString(sequenceNumber);
        }
        return Integer.toString(sequenceNumber);
    }

    public static int determineWaitTime(String localPath, int waitTime) {
        File inboxPath = new File(localPath);
        return inboxPath.listFiles(emlFileFilter).length * waitTime;
    }

    public static File createTempFile(InputStream mailStream) throws IOException {
        File tmpFile = Files.createTempFile(UUID.randomUUID().toString(), ".eml", new FileAttribute[0]).toFile();
        Files.copy(mailStream, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tmpFile;
    }

    public static HttpClient clientBuilder(String remoteUrl) throws Exception {
        try {
            if (remoteUrl.matches("^http://.*")) {
                HttpClient httpClient = new HttpClient();
                httpClient.start();
                return httpClient;
            }
            SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
            if (!ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().isVerifyCertificate()) {
                sslContextFactory.setTrustAll(true);
            }
            ClientConnector clientConnector = new ClientConnector();
            clientConnector.setSslContextFactory(sslContextFactory);
            HttpClient httpClient = new HttpClient(new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
            httpClient.start();
            return httpClient;
        }
        catch (NullPointerException ex) {
            HttpClient httpClient = new HttpClient();
            httpClient.start();
            return httpClient;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Matcher getChecksumFromResponse(String response) {
        return CHECKSUM_RESPONSE.matcher(response);
    }
}

