/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest;

import de.lwsystems.mailarchive.importrest.Main;
import de.lwsystems.mailarchive.importrest.endpoints.InboxServlet;
import de.lwsystems.mailarchive.importrest.filter.AuthorizationRequestFilter;
import de.lwsystems.mailarchive.importrest.utils.BennoRestSslUtils;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyServer {
    private static final Logger LOGGER = LogManager.getLogger(Main.class);
    private Server server;
    private HttpConfiguration config;
    private SslConnectionFactory sslConnectionFactory;
    private ServletContextHandler context;
    private FilterHolder filterHolder;

    public void configureHttpsServer(String host, int port) throws CertificateException, IOException, NoSuchAlgorithmException, KeyStoreException {
        this.createSslConnectionFactory();
        this.createHttpsConfiguration(port);
        this.createServletContextHandler();
        this.createFilterHolder();
        HttpConnectionFactory http11 = new HttpConnectionFactory(this.config);
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server, this.sslConnectionFactory, http11);
        connector.setPort(port);
        connector.setHost(host);
        this.server.addConnector(connector);
        this.server.setHandler(this.context);
    }

    public void configureHttpServer(String host, int port) {
        this.createHttpConfiguration();
        this.createServletContextHandler();
        this.createFilterHolder();
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(port);
        connector.setHost(host);
        this.server.addConnector(connector);
        this.server.setHandler(this.context);
    }

    private void createHttpsConfiguration(int port) {
        this.config = new HttpConfiguration();
        this.config.setSecureScheme("https");
        this.config.setSecurePort(port);
        this.config.setSendXPoweredBy(true);
        this.config.setSendServerVersion(true);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        this.config.addCustomizer(src);
    }

    private void createHttpConfiguration() {
        this.config = new HttpConfiguration();
    }

    private void createSslConnectionFactory() throws CertificateException, IOException, NoSuchAlgorithmException, KeyStoreException {
        SslContextFactory.Server sslContextFactory = (SslContextFactory.Server)BennoRestSslUtils.createSslConfiguration(true);
        this.sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
    }

    private void createServletContextHandler() {
        this.context = new ServletContextHandler();
        this.context.setContextPath("/rest");
        this.context.addServlet(InboxServlet.class, "/inbox/*").getRegistration().setMultipartConfig(new MultipartConfigElement("./tmp"));
    }

    private void createFilterHolder() {
        this.filterHolder = this.context.addFilter(AuthorizationRequestFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.filterHolder.setAsyncSupported(true);
    }

    public void stopServer() throws Exception {
        if (this.server.isRunning()) {
            LOGGER.info("Shutting down Benno Rest Import service");
            this.server.stop();
        }
    }

    public void startServer() throws Exception {
        if (!this.server.isRunning() && this.server != null) {
            this.server.start();
        }
    }
}

