/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.config.yaml;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.lwsystems.mailarchive.importrest.config.yaml.Configuration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;

public class ConfigurationHandler {
    private static ConfigurationHandler configHandler;
    Configuration configuration;

    private ConfigurationHandler(Path configPath) throws IOException {
        this.configuration = this.loadConfig(configPath);
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public static ConfigurationHandler getInstance() throws FileNotFoundException {
        if (configHandler == null) {
            throw new FileNotFoundException("Configuration file not found");
        }
        return configHandler;
    }

    public static ConfigurationHandler getInstance(Path configPath) throws IOException {
        if (configHandler == null) {
            configHandler = new ConfigurationHandler(configPath);
        }
        return configHandler;
    }

    public Configuration loadConfig(Path configPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        return mapper.readValue(configPath.toFile(), Configuration.class);
    }
}

