/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.endpoints;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.lwsystems.mailarchive.importrest.config.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.importrest.config.authorization.UploadResponse;
import de.lwsystems.mailarchive.importrest.services.MailHandling;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboxServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(InboxServlet.class);

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UploadResponse uploadResponse;
        try {
            if (request.getInputStream().available() == 0) {
                throw new IllegalArgumentException("Sent mail is empty");
            }
            uploadResponse = InboxServlet.processMail(request, request.getInputStream());
        }
        catch (Exception e) {
            UploadResponse uploadResponse2 = new UploadResponse(e.getMessage(), 500);
            LOGGER.error(uploadResponse2.getStatus() + " " + uploadResponse2.getMessage());
            response.setStatus(uploadResponse2.getStatus());
            if (uploadResponse2.getChecksum().equals("")) {
                response.getWriter().write("ERROR no checksum");
            } else {
                response.getWriter().write("ERROR " + uploadResponse2.getChecksum());
            }
            return;
        }
        if (uploadResponse.getStatus() != 200) {
            response.setStatus(uploadResponse.getStatus());
            LOGGER.error(uploadResponse.getStatus() + " " + uploadResponse.getMessage());
            if (uploadResponse.getChecksum().equals("")) {
                response.getWriter().write("ERROR no checksum");
            } else {
                response.getWriter().write("ERROR " + uploadResponse.getChecksum());
            }
            return;
        }
        response.setStatus(uploadResponse.getStatus());
        response.getWriter().write("OK " + uploadResponse.getChecksum());
    }

    static UploadResponse processMail(HttpServletRequest request, InputStream mailStream) throws Exception {
        MailHandling mailHandling = new MailHandling((AuthorizationResponse)request.getAttribute("response"), (String)request.getAttribute("authorization"));
        return mailHandling.processMail(mailStream);
    }

    static void handleUploadResponse(HttpServletResponse response, UploadResponse uploadResponse, ObjectMapper mapper) throws IOException {
        if (uploadResponse.getStatus() != 200) {
            response.setStatus(uploadResponse.getStatus());
            response.getWriter().write(mapper.writeValueAsString(uploadResponse));
            return;
        }
        ObjectNode json = mapper.createObjectNode();
        json.put("checksum", uploadResponse.getChecksum());
        response.setStatus(uploadResponse.getStatus());
        response.getWriter().write(mapper.writeValueAsString(uploadResponse));
    }
}

