/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.services;

import de.lwsystems.mailarchive.importrest.config.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.importrest.config.authorization.UploadResponse;
import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import de.lwsystems.mailarchive.importrest.models.Mail;
import de.lwsystems.mailarchive.importrest.services.ProcessFile;
import de.lwsystems.mailarchive.importrest.services.ReadMail;
import de.lwsystems.mailarchive.importrest.services.UploadMail;
import de.lwsystems.mailarchive.importrest.utils.BennoRestImportUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailHandling {
    private static final Logger LOGGER = LogManager.getLogger(MailHandling.class);
    private final String standardPathFallbackName = "standardPath";
    private final AuthorizationResponse authorizationResponse;
    private final String authHeader;

    public MailHandling(AuthorizationResponse authorizationResponse, String authHeader) {
        this.authorizationResponse = authorizationResponse;
        this.authHeader = authHeader;
    }

    public UploadResponse processMail(InputStream uploadedInputStream) throws Exception {
        String checksum = "";
        String finalFileName = "";
        boolean mailProcessed = false;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            uploadedInputStream.transferTo(baos);
            ByteArrayInputStream mailUploadStream = new ByteArrayInputStream(baos.toByteArray());
            Mail mail = this.readMail(mailUploadStream);
            if (mail == null) {
                return new UploadResponse("Sent mail is empty", 500);
            }
            checksum = BennoRestImportUtils.calculateMailChecksum(mail.getRawMail());
            try {
                for (Map.Entry<String, String[]> url : this.authorizationResponse.getData().getStorageurls().entrySet()) {
                    String[] containers;
                    String address;
                    if (url.getKey().toLowerCase().matches("^https?://.*") && !url.getKey().toLowerCase().contains(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getBaseUri().toLowerCase())) {
                        this.uploadMail(url.getKey(), baos, checksum, this.authHeader);
                        mailProcessed = true;
                        continue;
                    }
                    if (url.getKey().matches("^file://.*")) {
                        address = url.getKey().replace("file://", "");
                        containers = url.getValue();
                        finalFileName = ProcessFile.processFile(mail, address, containers, checksum);
                        mailProcessed = true;
                        continue;
                    }
                    if (!url.getKey().matches("standardPath")) continue;
                    address = url.getKey().replace("standardPath", ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getStandardPath());
                    containers = url.getValue();
                    finalFileName = ProcessFile.processFile(mail, address, containers, checksum);
                    mailProcessed = true;
                }
            }
            catch (NullPointerException ex) {
                mailProcessed = false;
            }
            if (!mailProcessed) {
                String address = ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getStandardPath();
                finalFileName = ProcessFile.processFile(mail, address, new String[0], checksum);
                LOGGER.warn("Mail: {} was not processed correctly. The mail was saved to the default path. If this was not intended, check your configuration.", (Object)finalFileName);
                return new UploadResponse(checksum, "Mail: " + checksum + "was not processed correctly. The mail was saved to the default path. If this was not intended, check your configuration.", 200, finalFileName);
            }
            return new UploadResponse(checksum, "Mail import was successful", 200, finalFileName);
        }
        catch (Exception ex) {
            return new UploadResponse(checksum, ex.getMessage(), 500, "");
        }
    }

    private Mail readMail(InputStream mailUploadStream) throws IOException {
        ReadMail readMail = new ReadMail();
        return readMail.convertInputStreamToMail(mailUploadStream);
    }

    private void uploadMail(String url, ByteArrayOutputStream baos, String checksum, String authHeader) throws Exception {
        ByteArrayInputStream tmpMailStream = new ByteArrayInputStream(baos.toByteArray());
        UploadMail uploadMail = new UploadMail();
        uploadMail.uploadMail(tmpMailStream, url, authHeader, checksum);
    }
}

