/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.services;

import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import de.lwsystems.mailarchive.importrest.models.Container;
import de.lwsystems.mailarchive.importrest.models.Mail;
import de.lwsystems.mailarchive.importrest.services.WriteMail;
import de.lwsystems.mailarchive.importrest.utils.BennoRestImportUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessFile {
    private static final Logger LOGGER = LogManager.getLogger(ProcessFile.class);
    private static final String fallbackContainerName = "no-container";

    public static String processFile(Mail mail, String address, String[] containers, String checksum) throws IOException, InterruptedException {
        String fileName = "";
        if (ProcessFile.checkContainersIfEmpty(containers, address)) {
            Container container = new Container(new ArrayList<String>(Arrays.asList(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getContainerBlacklist())), new ArrayList<String>(Arrays.asList(containers)), ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getHeader());
            mail.setBennoGwHeaders(container.getHeader());
            fileName = ProcessFile.setFileName(checksum, container.getContainerFileName().toString(), address);
            ProcessFile.saveMail(address, mail, fileName, ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getWaitTime());
        } else {
            fileName = ProcessFile.setFileName(checksum, fallbackContainerName, address);
            ProcessFile.saveMail(address, mail, fileName, ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getWaitTime());
        }
        return fileName;
    }

    private static boolean checkContainersIfEmpty(String[] containers, String address) {
        if (containers.length == 0) {
            LOGGER.error("No containers set for: {0}" + address);
            return false;
        }
        if (containers.length == 1 && containers[0].isEmpty()) {
            LOGGER.error("No containers set for: {0}" + address);
            return false;
        }
        return true;
    }

    private static String setFileName(String checksum, String containerName, String address) {
        String fileName = BennoRestImportUtils.setFilename(checksum, containerName, 0);
        int counter = 0;
        while (Files.exists(new File(address + File.separator + fileName + ".eml").toPath(), new LinkOption[0]) && counter < 1000) {
            fileName = BennoRestImportUtils.setFilename(checksum, containerName, ++counter);
        }
        return fileName;
    }

    private static void saveMail(String address, Mail mail, String fileName, int waitTime) throws IOException, InterruptedException {
        WriteMail writeMail = new WriteMail();
        writeMail.saveMail(address, mail, fileName, waitTime);
    }
}

