/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.services;

import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import de.lwsystems.mailarchive.importrest.models.Mail;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReadMail {
    private static final Logger LOGGER = LogManager.getLogger(ReadMail.class);

    public Mail convertInputStreamToMail(InputStream inputStream) throws IOException {
        return this.getMail(inputStream);
    }

    private Mail getMail(InputStream inputStream) throws IOException {
        Mail mail = new Mail();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream secretHeaderStream = new ByteArrayOutputStream();
        boolean isHeader = true;
        int tempByte = inputStream.read();
        if (tempByte == -1) {
            return null;
        }
        boolean receivedNewline = false;
        ByteArrayOutputStream tempLine = new ByteArrayOutputStream(1024);
        block8: while (isHeader) {
            List<String> result;
            if (tempByte == -1) {
                isHeader = false;
                continue;
            }
            if (receivedNewline) {
                receivedNewline = false;
                switch (tempByte) {
                    case 10: {
                        isHeader = false;
                        tempLine.write(tempByte);
                        tempByte = inputStream.read();
                        if (tempByte == 13) {
                            tempLine.write(tempByte);
                            tempByte = inputStream.read();
                        }
                        result = this.getSecretHeaderFromLine(tempLine.toString());
                        this.setHeaderResultToMatchingStream(outputStream, secretHeaderStream, result, tempLine);
                        continue block8;
                    }
                    case 13: {
                        isHeader = false;
                        tempLine.write(tempByte);
                        tempByte = inputStream.read();
                        if (tempByte == 10) {
                            tempLine.write(tempByte);
                            tempByte = inputStream.read();
                        }
                        result = this.getSecretHeaderFromLine(tempLine.toString());
                        this.setHeaderResultToMatchingStream(outputStream, secretHeaderStream, result, tempLine);
                        continue block8;
                    }
                }
                tempLine.write(tempByte);
                tempByte = inputStream.read();
                continue;
            }
            switch (tempByte) {
                case 10: {
                    receivedNewline = true;
                    tempLine.write(tempByte);
                    tempByte = inputStream.read();
                    if (tempByte == 13) {
                        tempLine.write(tempByte);
                        tempByte = inputStream.read();
                    }
                    result = this.getSecretHeaderFromLine(tempLine.toString());
                    this.setHeaderResultToMatchingStream(outputStream, secretHeaderStream, result, tempLine);
                    continue block8;
                }
                case 13: {
                    receivedNewline = true;
                    tempLine.write(tempByte);
                    tempByte = inputStream.read();
                    if (tempByte == 10) {
                        tempLine.write(tempByte);
                        tempByte = inputStream.read();
                    }
                    result = this.getSecretHeaderFromLine(tempLine.toString());
                    this.setHeaderResultToMatchingStream(outputStream, secretHeaderStream, result, tempLine);
                    continue block8;
                }
            }
            tempLine.write(tempByte);
            tempByte = inputStream.read();
        }
        if (tempByte != -1) {
            outputStream.write(tempByte);
            outputStream.write(IOUtils.toByteArray(inputStream));
        }
        mail.setSecretHeaders(secretHeaderStream);
        mail.setRawMail(outputStream);
        return mail;
    }

    private void setHeaderResultToMatchingStream(ByteArrayOutputStream outputStream, ByteArrayOutputStream secretHeaderStream, List<String> result, ByteArrayOutputStream tempLine) throws IOException {
        if (result.isEmpty()) {
            outputStream.write(tempLine.toByteArray());
            tempLine.reset();
        } else {
            String[] header = tempLine.toString().split(":", 2);
            LOGGER.debug("Remove secret header: {}", (Object)header[0]);
            secretHeaderStream.write(tempLine.toByteArray());
            tempLine.reset();
        }
    }

    private List<String> getSecretHeaderFromLine(String headerLine) throws FileNotFoundException {
        String[] header = headerLine.split(":", 2);
        if (header.length >= 2) {
            return ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getSecretHeaders().stream().filter(x -> x.contains(header[0])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

