/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.services;

import de.lwsystems.mailarchive.importrest.utils.BennoRestImportUtils;
import java.io.InputStream;
import java.util.regex.Matcher;
import javax.ws.rs.ProcessingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.http.HttpMethod;

public class UploadMail {
    private static final Logger LOGGER = LogManager.getLogger(UploadMail.class);

    public void uploadMail(InputStream mailStream, String url, String authHeader, String checksum) throws Exception {
        ContentResponse response = this.uploadFile(mailStream, url, authHeader);
        Matcher successChecksum = BennoRestImportUtils.getChecksumFromResponse(response.getContentAsString());
        if (successChecksum.find()) {
            String remoteChecksum = successChecksum.group();
            if (!remoteChecksum.equalsIgnoreCase(checksum)) {
                LOGGER.warn("The checksum from {} {} is not equal to the local checksum {}.", (Object)url, (Object)remoteChecksum, (Object)checksum);
            }
        } else {
            LOGGER.warn("No correct checksum response from {} was given.", (Object)url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentResponse uploadFile(InputStream mailStream, String url, String authHeader) throws Exception {
        HttpClient client = BennoRestImportUtils.clientBuilder(url);
        try {
            InputStreamRequestContent content = new InputStreamRequestContent(mailStream);
            ContentResponse response = client.newRequest(url).method(HttpMethod.PUT).headers(headers -> headers.add("Authorization", authHeader)).body(content).send();
            if (response.getStatus() != 200) {
                LOGGER.error("Forward to {} was not successful: {} {}", (Object)url, (Object)response.getStatus(), (Object)response.getContentAsString());
                String authUser = BennoRestImportUtils.userFromAuthHeader(authHeader);
                throw new ProcessingException("Upload to " + url + " as \"" + authUser + "\" was not successful: " + response.getStatus() + " " + response.getContentAsString());
            }
            LOGGER.info("Forward to {} was successful: {} {}", (Object)url, (Object)response.getStatus(), (Object)response.getContentAsString());
            ContentResponse contentResponse = response;
            return contentResponse;
        }
        finally {
            try {
                client.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Could not stop http-client: {}", (Object)ex.getMessage());
            }
        }
    }
}

