/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.importrest.utils;

import de.lwsystems.mailarchive.importrest.config.yaml.ConfigurationHandler;
import de.lwsystems.mailarchive.importrest.utils.SSLPemParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class BennoRestSslUtils {
    public static KeyStore createKeystore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        Security.addProvider(new BouncyCastleProvider());
        Objects.requireNonNull(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslCertPath(), "sslCertPath in config must not be null");
        Objects.requireNonNull(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslPrivateKeyPath(), "sslPrivateKeyPath in config must not be null");
        Certificate[] cert = BennoRestSslUtils.getCertificates(Paths.get(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslCertPath(), new String[0]).toFile());
        PrivateKey privateKey = BennoRestSslUtils.getPrivateKey(Paths.get(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslPrivateKeyPath(), new String[0]).toFile());
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null, null);
        keystore.setKeyEntry("KeyStore-Benno-Import-Rest", privateKey, ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslKeyStorePass().toCharArray(), cert);
        return keystore;
    }

    public static PrivateKey getPrivateKey(File pemFile) throws IOException {
        KeyPair pair = null;
        try (SSLPemParser reader = new SSLPemParser(new FileReader(pemFile));){
            Object pemParser = new SSLPemParser(reader).receiveObject();
            if (pemParser instanceof PEMKeyPair) {
                pair = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)pemParser);
                PrivateKey privateKey = pair.getPrivate();
                return privateKey;
            }
            if (pemParser instanceof PrivateKeyInfo) {
                PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(PrivateKeyInfo.getInstance(pemParser));
                return privateKey;
            }
        }
        throw new IllegalArgumentException("Could not parse private key");
    }

    public static X509Certificate[] getCertificates(File certificatePem) throws IOException, CertificateException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try (PEMParser pemParser = new PEMParser(new FileReader(certificatePem));){
            Object pemObject = pemParser.readObject();
            while (pemObject != null) {
                result.add(new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)pemObject));
                pemObject = pemParser.readObject();
            }
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    public static SslContextFactory createSslConfiguration(boolean isServerClient) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore keystore = BennoRestSslUtils.createKeystore();
        SslContextFactory sslContextFactory = null;
        sslContextFactory = isServerClient ? new SslContextFactory.Server() : new SslContextFactory.Client();
        Objects.requireNonNull(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore(), "sslKeyStore in config must not be null");
        sslContextFactory.setKeyStore(keystore);
        sslContextFactory.setKeyStorePassword(ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslKeyStorePass());
        String keyStoreType = "PKCS12";
        try {
            if (!ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslKeyStoreType().isEmpty()) {
                keyStoreType = ConfigurationHandler.getInstance().getConfig().getBenno().getImporter().getRest().getServer().getSslKeyStore().getSslKeyStoreType();
            }
        }
        catch (NullPointerException ex) {
            keyStoreType = "PKCS12";
        }
        sslContextFactory.setKeyStoreType(keyStoreType);
        return sslContextFactory;
    }
}

