/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest;

import de.lwsystems.mailarchive.bennoimport.core.auth.IRequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RestCall;
import de.lwsystems.mailarchive.bennoimport.core.client.HttpClientFactory;
import de.lwsystems.mailarchive.bennoimport.core.client.RestHttpClientFactory;
import de.lwsystems.mailarchive.bennoimport.core.services.CalculateChecksumService;
import de.lwsystems.mailarchive.bennoimport.core.services.DirectoryHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.FileHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.ICalculateChecksum;
import de.lwsystems.mailarchive.bennoimport.core.services.IDirectoryHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.IFileHandler;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailDelete;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailValidation;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailWrite;
import de.lwsystems.mailarchive.bennoimport.core.services.IProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.IStreamReader;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.MailCreator;
import de.lwsystems.mailarchive.bennoimport.core.services.MailDelete;
import de.lwsystems.mailarchive.bennoimport.core.services.MailStreamReader;
import de.lwsystems.mailarchive.bennoimport.core.services.MailValidationService;
import de.lwsystems.mailarchive.bennoimport.core.services.MailWrite;
import de.lwsystems.mailarchive.bennoimport.core.services.ProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.RestUploadMail;
import de.lwsystems.mailarchive.bennoimport.core.services.TempFileHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.BennoMailEnvelopeGenerator;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IEnvelopeGenerator;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailConverter;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IMicrosoftJournalMailParserFactory;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.IStreamCombiner;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.MicrosoftJournalMail;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.MicrosoftJournalMailHandlingService;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.MicrosoftJournalMailTextParserFactory;
import de.lwsystems.mailarchive.bennoimport.core.services.msjournal.SequenceInputStreamCombiner;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoRestSslUtils;
import de.lwsystems.mailarchive.bennoimport.rest.config.yaml.Benno;
import de.lwsystems.mailarchive.bennoimport.rest.config.yaml.rest.SslKeyStore;
import de.lwsystems.mailarchive.bennoimport.rest.endpoints.ArchiveServlet;
import de.lwsystems.mailarchive.bennoimport.rest.endpoints.InboxServlet;
import de.lwsystems.mailarchive.bennoimport.rest.filter.ArchiveAuthorizationRequestFilter;
import de.lwsystems.mailarchive.bennoimport.rest.filter.InboxAuthorizationRequestFilter;
import de.lwsystems.mailarchive.bennoimport.rest.handler.AuthorizationHeaderFactory;
import de.lwsystems.mailarchive.bennoimport.rest.models.EndpointCounterFactory;
import de.lwsystems.mailarchive.bennoimport.rest.services.LocalFileHandlingService;
import de.lwsystems.mailarchive.bennoimport.rest.services.MailHandlingService;
import de.lwsystems.mailarchive.bennoimport.rest.services.MailProcessingService;
import de.lwsystems.mailarchive.bennoimport.rest.services.StorageUrlHandlingService;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.EnumSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyServer {
    private static final Logger LOGGER = LogManager.getLogger(JettyServer.class);
    private static final String TMP_DIRECTORY = "./tmp";
    private static final String CONTEXT_PATH = "/rest";
    private static final String ARCHIVE_SERVLET_PATH = "/archive/*";
    private static final String INBOX_SERVLET_PATH = "/inbox/*";
    private Server server;
    private HttpConfiguration httpConfig;
    private ServletContextHandler context;

    public void configureHttpsServer(String host, int port, Benno bennoConfig) throws CertificateException, IOException, NoSuchAlgorithmException, KeyStoreException {
        SslConnectionFactory sslConnectionFactory = this.createSslConnectionFactory(bennoConfig.getRestServer().getSslKeyStore());
        this.createHttpsConfiguration(port);
        this.setupServerConnector(host, port, sslConnectionFactory);
        this.setupServletContext(bennoConfig);
    }

    public void configureHttpServer(String host, int port, Benno bennoConfig) {
        this.createHttpConfiguration();
        this.setupServerConnector(host, port, null);
        this.setupServletContext(bennoConfig);
    }

    private void createHttpsConfiguration(int port) {
        this.httpConfig = new HttpConfiguration();
        this.httpConfig.setSecureScheme("https");
        this.httpConfig.setSecurePort(port);
        this.httpConfig.setSendXPoweredBy(true);
        this.httpConfig.setSendServerVersion(true);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        this.httpConfig.addCustomizer((HttpConfiguration.Customizer)src);
    }

    private void createHttpConfiguration() {
        this.httpConfig = new HttpConfiguration();
    }

    private SslConnectionFactory createSslConnectionFactory(SslKeyStore sslKeyStoreConfig) throws CertificateException, IOException, NoSuchAlgorithmException, KeyStoreException {
        SslContextFactory.Server sslContextFactory = (SslContextFactory.Server)BennoRestSslUtils.createSslContextFactory((boolean)true, (String)sslKeyStoreConfig.getSslCertPath(), (String)sslKeyStoreConfig.getSslPrivateKeyPath(), (String)sslKeyStoreConfig.getSslKeyStorePass(), (String)sslKeyStoreConfig.getSslKeyStoreType(), (String)"Benno-Import-Rest");
        return new SslConnectionFactory(sslContextFactory, "http/1.1");
    }

    private void setupServerConnector(String host, int port, SslConnectionFactory sslConnectionFactory) {
        ServerConnector connector;
        this.server = new Server();
        if (sslConnectionFactory != null) {
            HttpConnectionFactory http11 = new HttpConnectionFactory(this.httpConfig);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, http11});
        } else {
            connector = new ServerConnector(this.server);
        }
        connector.setPort(port);
        connector.setHost(host);
        this.server.addConnector((Connector)connector);
    }

    private void setupServletContext(Benno bennoConfig) {
        this.context = new ServletContextHandler();
        this.context.setContextPath(CONTEXT_PATH);
        MailDelete mailDelete = new MailDelete();
        MailWrite mailWrite = new MailWrite((IMailDelete)mailDelete);
        DirectoryHandler directoryHandler = new DirectoryHandler();
        ProcessFile processFile = new ProcessFile((IMailWrite)mailWrite, bennoConfig.getRestServer().getContainerBlacklist(), bennoConfig.getRestServer().getHeader(), bennoConfig.getWaitTime(), bennoConfig.getInboxEndpoint().isSaveWithGWHeader());
        RequestService requestService = new RequestService(new RestCall((HttpClientFactory)new RestHttpClientFactory(), bennoConfig.getInboxEndpoint().getHttpClient()));
        FileHandler fileHandler = new FileHandler();
        MailStreamReader streamReader = new MailStreamReader(bennoConfig.getInboxEndpoint().getSecretHeaders());
        this.setupArchiveServlet(new MailCreator((IStreamReader)streamReader), new RestUploadMail(requestService), (IProcessFile)processFile, (IFileHandler)fileHandler, bennoConfig, (IDirectoryHandler)directoryHandler);
        this.setupInboxServlet(new MailCreator((IStreamReader)streamReader), new RestUploadMail(requestService), (IProcessFile)processFile, (IFileHandler)fileHandler, bennoConfig, (IDirectoryHandler)directoryHandler, bennoConfig.getInboxEndpoint().getHostnames());
        this.setupAuthorizationFilter(requestService, bennoConfig);
        this.server.setHandler((Handler)this.context);
    }

    private void setupArchiveServlet(MailCreator mailCreator, RestUploadMail restUploadMail, IProcessFile processFile, IFileHandler fileHandler, Benno bennoConfig, IDirectoryHandler directoryHandler) {
        IMailHandling mailHandlingService = this.createMailHandlingService(mailCreator, restUploadMail, processFile, fileHandler, bennoConfig, directoryHandler);
        ArchiveServlet archiveServlet = new ArchiveServlet(mailHandlingService);
        ServletHolder servletHolder = new ServletHolder((Servlet)archiveServlet);
        servletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement(TMP_DIRECTORY));
        this.context.addServlet(servletHolder, ARCHIVE_SERVLET_PATH);
    }

    private void setupInboxServlet(MailCreator mailCreator, RestUploadMail restUploadMail, IProcessFile processFile, IFileHandler fileHandler, Benno bennoConfig, IDirectoryHandler directoryHandler, List<String> hostnames) {
        IMailHandling mailHandlingService = this.createMailHandlingService(mailCreator, restUploadMail, processFile, fileHandler, bennoConfig, directoryHandler);
        MailValidationService mailValidationService = new MailValidationService((IMailCreator)mailCreator);
        CalculateChecksumService checksumService = new CalculateChecksumService();
        TempFileHandlingService tempFileHandlingService = new TempFileHandlingService(fileHandler, bennoConfig.getTempFiles().getTempFolder(), processFile, directoryHandler);
        MicrosoftJournalMailTextParserFactory microsoftJournalMailParserFactory = new MicrosoftJournalMailTextParserFactory();
        BennoMailEnvelopeGenerator envelopeGenerator = new BennoMailEnvelopeGenerator();
        SequenceInputStreamCombiner streamCombiner = new SequenceInputStreamCombiner();
        MicrosoftJournalMail converter = new MicrosoftJournalMail((IMicrosoftJournalMailParserFactory)microsoftJournalMailParserFactory, (IEnvelopeGenerator)envelopeGenerator, (IStreamCombiner)streamCombiner);
        MicrosoftJournalMailHandlingService journalMailHandlingService = new MicrosoftJournalMailHandlingService((IJournalMailConverter)converter, (ITempFileHandling)tempFileHandlingService, (IMailValidation)mailValidationService, (ICalculateChecksum)checksumService);
        InboxServlet inboxServlet = new InboxServlet(mailHandlingService, (IJournalMailHandlingService)journalMailHandlingService, hostnames);
        ServletHolder servletHolder = new ServletHolder((Servlet)inboxServlet);
        servletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement(TMP_DIRECTORY));
        this.context.addServlet(servletHolder, INBOX_SERVLET_PATH);
    }

    private IMailHandling createMailHandlingService(MailCreator mailCreator, RestUploadMail restUploadMail, IProcessFile processFile, IFileHandler fileHandler, Benno bennoConfig, IDirectoryHandler directoryHandler) {
        MailValidationService mailValidationService = new MailValidationService((IMailCreator)mailCreator);
        CalculateChecksumService checksumService = new CalculateChecksumService();
        TempFileHandlingService tempFileHandlingService = new TempFileHandlingService(fileHandler, bennoConfig.getTempFiles().getTempFolder(), processFile, directoryHandler);
        StorageUrlHandlingService storageUrlHandling = new StorageUrlHandlingService(restUploadMail, bennoConfig.getJwt(), processFile, (ITempFileHandling)tempFileHandlingService, new EndpointCounterFactory(bennoConfig.getInboxEndpoint().getMinBackends()));
        LocalFileHandlingService localFileHandling = new LocalFileHandlingService(processFile, bennoConfig.getArchiveEndpoint().getInboxPath(), (ITempFileHandling)tempFileHandlingService);
        MailProcessingService mailProcessingService = new MailProcessingService(storageUrlHandling, localFileHandling);
        return new MailHandlingService((IMailValidation)mailValidationService, (ICalculateChecksum)checksumService, mailProcessingService);
    }

    private void setupAuthorizationFilter(RequestService requestService, Benno bennoConfig) {
        ArchiveAuthorizationRequestFilter archiveAuthorizationRequestFilter = new ArchiveAuthorizationRequestFilter(new AuthorizationHeaderFactory((IRequestService)requestService), bennoConfig.getJwt(), bennoConfig.getArchiveEndpoint());
        InboxAuthorizationRequestFilter inboxAuthorizationRequestFilter = new InboxAuthorizationRequestFilter(new AuthorizationHeaderFactory((IRequestService)requestService), bennoConfig.getJwt(), bennoConfig.getInboxEndpoint().getStorageUrl(), bennoConfig.getRestServer());
        FilterHolder archiveAuthorizationRequestFilterHolder = new FilterHolder((Filter)archiveAuthorizationRequestFilter);
        archiveAuthorizationRequestFilterHolder.setAsyncSupported(true);
        FilterHolder inboxAuthorizationRequestFilterHolder = new FilterHolder((Filter)inboxAuthorizationRequestFilter);
        inboxAuthorizationRequestFilterHolder.setAsyncSupported(true);
        this.context.addFilter(archiveAuthorizationRequestFilterHolder, ARCHIVE_SERVLET_PATH, EnumSet.of(DispatcherType.REQUEST));
        this.context.addFilter(inboxAuthorizationRequestFilterHolder, INBOX_SERVLET_PATH, EnumSet.of(DispatcherType.REQUEST));
    }

    public void stopServer() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            LOGGER.info("Shutting down Benno Rest Import service");
            this.server.stop();
        }
    }

    public void startServer() throws Exception {
        if (this.server != null && !this.server.isRunning()) {
            this.server.start();
            LOGGER.info("Benno Rest Import service started");
        }
    }

    public Server getServer() {
        return this.server;
    }
}

