/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.config.yaml.endpoints;

import de.lwsystems.mailarchive.bennoimport.core.config.yaml.httpclient.HttpClient;
import de.lwsystems.mailarchive.bennoimport.core.config.yaml.storageurl.StorageUrl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboxEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(InboxEndpoint.class);
    private List<String> secretHeaders;
    private boolean saveWithGWHeader = true;
    private HttpClient httpClient;
    private StorageUrl storageUrl;
    private int minBackends = 2;
    private List<String> hostnames = InboxEndpoint.getDefaultHostnames();

    public List<String> getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setSecretHeaders(List<String> secretHeaders) {
        this.secretHeaders = secretHeaders;
    }

    public boolean isSaveWithGWHeader() {
        return this.saveWithGWHeader;
    }

    public void setSaveWithGWHeader(boolean saveWithGWHeader) {
        this.saveWithGWHeader = saveWithGWHeader;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public StorageUrl getStorageUrl() {
        return this.storageUrl;
    }

    public void setStorageUrl(StorageUrl storageUrl) {
        this.storageUrl = storageUrl;
    }

    public int getMinBackends() {
        return this.minBackends;
    }

    public void setMinBackends(int minBackends) {
        this.minBackends = minBackends;
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public void setHostnames(List<String> hostnames) {
        this.hostnames = hostnames;
    }

    private static List<String> getDefaultHostnames() {
        try {
            String canonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
            LOGGER.debug("Set hostname to: {}", (Object)canonicalHostName);
            return List.of(canonicalHostName);
        }
        catch (UnknownHostException ex) {
            LOGGER.error("Could not get hostname {}. Set localhost as default hostname when config is empty.", (Object)ex.getMessage());
            return List.of("localhost");
        }
    }
}

