/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.endpoints;

import de.lwsystems.mailarchive.bennoimport.core.models.authorization.UploadResponse;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailHandling;
import de.lwsystems.mailarchive.bennoimport.rest.responses.EndpointResponseUtils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(ArchiveServlet.class);
    private final IMailHandling mailHandlingService;

    public ArchiveServlet(IMailHandling mailHandlingService) {
        this.mailHandlingService = mailHandlingService;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getContentLength() == 0) {
            try {
                EndpointResponseUtils.sendErrorResponse(response, this.createUploadResponse("Empty content not allowed", 400));
            }
            catch (IOException ex) {
                LOGGER.error("Failed to send error response for empty content", (Throwable)ex);
            }
        } else {
            try {
                UploadResponse uploadResponse = this.handleMailUpload((InputStream)request.getInputStream());
                this.sendResponse(response, uploadResponse);
            }
            catch (Exception ex) {
                try {
                    EndpointResponseUtils.sendErrorResponse(response, this.createUploadResponse(ex.getMessage(), 500));
                }
                catch (IOException ioEx) {
                    LOGGER.error("Failed to send error response after processing failure", (Throwable)ioEx);
                }
            }
        }
    }

    private UploadResponse handleMailUpload(InputStream mailInputStream) {
        try {
            LOGGER.debug("Processing archive mail");
            return this.mailHandlingService.processMail(mailInputStream);
        }
        catch (IOException ex) {
            LOGGER.error("Error when processing archive mail", (Throwable)ex);
            return this.createUploadResponse(ex.getMessage(), 500);
        }
    }

    private void sendResponse(HttpServletResponse httpServletResponse, UploadResponse uploadResponse) throws IOException {
        if (uploadResponse.getStatus() == 200) {
            LOGGER.debug("Mail processed successfully with checksum: {}", (Object)uploadResponse.getChecksum());
            EndpointResponseUtils.sendSuccessResponse(httpServletResponse, uploadResponse);
        } else {
            LOGGER.debug("Error processing archive mail with checksum: {}", (Object)uploadResponse.getChecksum());
            EndpointResponseUtils.sendErrorResponse(httpServletResponse, uploadResponse);
        }
    }

    private UploadResponse createUploadResponse(String responseMessage, int httpStatus) {
        return new UploadResponse(responseMessage, httpStatus);
    }
}

