/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.handler;

import de.lwsystems.mailarchive.bennoimport.core.auth.IRequestService;
import de.lwsystems.mailarchive.bennoimport.core.auth.RestAuthResponse;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.HttpClientException;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoImportUtils;
import de.lwsystems.mailarchive.bennoimport.rest.handler.IAuthorizationHeaderHandler;
import de.lwsystems.mailarchive.bennoimport.rest.records.AuthenticationResult;
import java.io.FileNotFoundException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicAuthHandler
implements IAuthorizationHeaderHandler {
    private static final Logger LOGGER = LogManager.getLogger(BasicAuthHandler.class);
    private final IRequestService requestService;

    public BasicAuthHandler(IRequestService requestService) {
        this.requestService = requestService;
    }

    @Override
    public AuthenticationResult handleAuthorizationHeader(String authorizationHeader, String importId, Map<String, String> requestHeaders, String authorizationUrl) throws FileNotFoundException, HttpClientException {
        Map queryParams = BennoImportUtils.createStorageUrlUserParamsWithPassword((String)authorizationHeader);
        LOGGER.debug("Get StorageUrls with Basic auth from Import-Rest API: {} with user: {}", (Object)authorizationUrl, (Object)importId);
        RestAuthResponse response = this.requestService.postRequest(requestHeaders, queryParams, authorizationUrl);
        return new AuthenticationResult(response, importId);
    }
}

