/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.services;

import de.lwsystems.mailarchive.bennoimport.core.exceptions.FileIsAlreadyWrittenException;
import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.services.IProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.rest.services.ILocalFileHandling;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalFileHandlingService
implements ILocalFileHandling {
    private static final Logger LOGGER = LogManager.getLogger(LocalFileHandlingService.class);
    private final IProcessFile processFile;
    private final String defaultInboxPath;
    private final ITempFileHandling tempFileHandling;
    private static final String TEMP_FILE_DIRECTORY_NAME = "archive";

    public LocalFileHandlingService(IProcessFile processFile, String defaultInboxPath, ITempFileHandling tempFileHandling) {
        this.processFile = processFile;
        this.defaultInboxPath = defaultInboxPath;
        this.tempFileHandling = tempFileHandling;
    }

    @Override
    public void processLocalFile(ByteArrayOutputStream mailOutputStream, Mail mail, String mailChecksum) throws IOException {
        Path tempFile = null;
        try {
            tempFile = this.tempFileHandling.createTempFileForLocalFileWithDirPath(mail, mailChecksum, TEMP_FILE_DIRECTORY_NAME);
            this.processLocalPath(mail, mailChecksum);
            this.tempFileHandling.handleTempFile(tempFile, true);
        }
        catch (IOException ex) {
            LOGGER.error("Error while processing mail: {}.", (Object)ex.getMessage());
            this.tempFileHandling.handleTempFile(tempFile, false);
            throw ex;
        }
        catch (FileIsAlreadyWrittenException ex) {
            LOGGER.warn("File is already written: {}.", (Object)ex.getMessage());
            this.tempFileHandling.handleTempFile(tempFile, false);
        }
        catch (Exception ex) {
            LOGGER.debug("Unknown error processing local file: {}.", (Object)ex.getMessage());
            this.tempFileHandling.handleTempFile(tempFile, false);
            throw ex;
        }
    }

    private void processLocalPath(Mail mail, String mailChecksum) throws IOException, FileIsAlreadyWrittenException {
        if (!Files.exists(Path.of(this.defaultInboxPath, new String[0]), new LinkOption[0])) {
            LOGGER.error("Inbox path does not exist");
            throw new IOException("Inbox path does not exist");
        }
        this.processFile.processFile(mail, this.defaultInboxPath, mailChecksum);
        LOGGER.info("Mail {} written to local inboxPath: {}", (Object)mailChecksum, (Object)this.defaultInboxPath);
    }
}

