/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.services;

import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.UploadResponse;
import de.lwsystems.mailarchive.bennoimport.core.services.ICalculateChecksum;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailProcessing;
import de.lwsystems.mailarchive.bennoimport.core.services.IMailValidation;
import de.lwsystems.mailarchive.bennoimport.core.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailHandlingService
implements IMailHandling {
    private static final Logger LOGGER = LogManager.getLogger(MailHandlingService.class);
    private final IMailValidation mailValidationService;
    private final ICalculateChecksum checksumService;
    private final IMailProcessing mailProcessingService;

    public MailHandlingService(IMailValidation mailValidationService, ICalculateChecksum checksumService, IMailProcessing mailProcessingService) {
        this.mailValidationService = mailValidationService;
        this.checksumService = checksumService;
        this.mailProcessingService = mailProcessingService;
    }

    public UploadResponse processMail(InputStream mailInputStream, AuthorizationResponse authorizationResponse, Map<String, String> requestHeaders, List<String> hostnames) throws IOException {
        return this.processMailInternal(mailInputStream, (mailOutputStream, mail, mailChecksum) -> this.mailProcessingService.processMailUrls(mailOutputStream, mail, mailChecksum, authorizationResponse, requestHeaders, hostnames));
    }

    public UploadResponse processMail(InputStream mailInputStream) throws IOException {
        return this.processMailInternal(mailInputStream, (arg_0, arg_1, arg_2) -> ((IMailProcessing)this.mailProcessingService).processLocalFile(arg_0, arg_1, arg_2));
    }

    private UploadResponse processMailInternal(InputStream mailStream, MailProcessor mailProcessor) throws IOException {
        try (ByteArrayOutputStream mailOutputStream = StreamUtils.convertToByteArrayOutputStream((InputStream)mailStream);){
            Optional mail = this.mailValidationService.createMail((InputStream)new ByteArrayInputStream(mailOutputStream.toByteArray()));
            if (mail.isEmpty()) {
                LOGGER.error("Sent mail is empty");
                UploadResponse uploadResponse = new UploadResponse("Sent mail is empty", 500);
                return uploadResponse;
            }
            String mailChecksum = this.checksumService.calculateMailChecksum((Mail)mail.get());
            try {
                UploadResponse uploadResponse = mailProcessor.processMail(mailOutputStream, (Mail)mail.get(), mailChecksum);
                return uploadResponse;
            }
            catch (Exception ex) {
                UploadResponse uploadResponse;
                block11: {
                    LOGGER.error("Error when processing mail: {}", (Object)ex.getMessage());
                    uploadResponse = new UploadResponse(mailChecksum, ex.getMessage(), 500, mailChecksum);
                    if (mailOutputStream == null) break block11;
                    mailOutputStream.close();
                }
                return uploadResponse;
            }
        }
    }

    @FunctionalInterface
    private static interface MailProcessor {
        public UploadResponse processMail(ByteArrayOutputStream var1, Mail var2, String var3) throws IOException;
    }
}

