/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.services;

import de.lwsystems.mailarchive.bennoimport.core.config.yaml.Jwt;
import de.lwsystems.mailarchive.bennoimport.core.exceptions.FileIsAlreadyWrittenException;
import de.lwsystems.mailarchive.bennoimport.core.models.Mail;
import de.lwsystems.mailarchive.bennoimport.core.models.authorization.AuthorizationResponse;
import de.lwsystems.mailarchive.bennoimport.core.services.IProcessFile;
import de.lwsystems.mailarchive.bennoimport.core.services.ITempFileHandling;
import de.lwsystems.mailarchive.bennoimport.core.services.RestUploadMail;
import de.lwsystems.mailarchive.bennoimport.core.utils.BennoHeaderUtils;
import de.lwsystems.mailarchive.bennoimport.core.utils.UrlStringUtils;
import de.lwsystems.mailarchive.bennoimport.rest.models.EndpointCounter;
import de.lwsystems.mailarchive.bennoimport.rest.models.EndpointCounterFactory;
import de.lwsystems.mailarchive.bennoimport.rest.services.IStorageUrlHandling;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageUrlHandlingService
implements IStorageUrlHandling {
    private static final Logger LOGGER = LogManager.getLogger(StorageUrlHandlingService.class);
    private final RestUploadMail restUploadMail;
    private final Jwt jwtConfig;
    private final IProcessFile processFile;
    private final ITempFileHandling tempFileHandling;
    private final EndpointCounterFactory endpointCounterFactory;
    private EndpointCounter endpointCounter;

    public StorageUrlHandlingService(RestUploadMail restUploadMail, Jwt jwtConfig, IProcessFile processFile, ITempFileHandling tempFileHandling, EndpointCounterFactory endpointCounterFactory) {
        this.restUploadMail = restUploadMail;
        this.jwtConfig = jwtConfig;
        this.processFile = processFile;
        this.tempFileHandling = tempFileHandling;
        this.endpointCounterFactory = endpointCounterFactory;
    }

    @Override
    public boolean processMailUrls(ByteArrayOutputStream mailOutputStream, Mail mail, String mailChecksum, AuthorizationResponse authorizationResponse, Map<String, String> requestHeaders, List<String> hostnames) throws IOException {
        this.endpointCounter = this.endpointCounterFactory.create();
        if (authorizationResponse.getData().getStorageUrls().isEmpty()) {
            LOGGER.warn("StorageUrls are empty. Save mail into temp folder.");
            try {
                Path tmpFile = this.tempFileHandling.createTempFileForStorageUrls(mail, mailChecksum);
                this.tempFileHandling.handleTempFile(tmpFile, false);
            }
            catch (Exception ex) {
                LOGGER.error("Can't create tempFile: {}", (Object)ex.getMessage());
                throw ex;
            }
        } else {
            this.handleStorageUrl(authorizationResponse, mail, mailChecksum, requestHeaders, hostnames);
        }
        if (this.endpointCounter.isBackendCountZero()) {
            LOGGER.warn("No backend could be reached. The mail is saved under the temp folder.");
        }
        return this.endpointCounter.checkBackendsReached();
    }

    private void handleStorageUrl(AuthorizationResponse authorizationResponse, Mail mail, String mailChecksum, Map<String, String> headers, List<String> hostnames) {
        Path localTmpFile = null;
        for (Map.Entry<String, String[]> entry : authorizationResponse.getData().getStorageUrls().entrySet()) {
            try {
                localTmpFile = this.tempFileHandling.createTempFileForStorageUrlsWithGwHeaderAndUrl(mail, mailChecksum, (String[])entry.getValue(), (String)entry.getKey());
                Map mailHeaders = BennoHeaderUtils.setBennoGwHeaderToMailHeaders(headers, (String[])((String[])entry.getValue()));
                boolean isMailProcessed = this.handleStorageUrl(entry, mail, mailChecksum, (Map<String, String>)mailHeaders, hostnames);
                this.tempFileHandling.handleTempFile(localTmpFile, isMailProcessed);
            }
            catch (Exception ex) {
                this.tempFileHandling.handleTempFile(localTmpFile, false);
                LOGGER.warn("Error while processing mail {}: {}. Set mailProcess to false", (Object)mailChecksum, (Object)ex.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleStorageUrl(Map.Entry<String, String[]> storageUrls, Mail mail, String mailChecksum, Map<String, String> mailHeaders, List<String> hostnames) throws FileIsAlreadyWrittenException, IOException {
        String storageUrlEndpoint = storageUrls.getKey();
        String[] storageUrlGwHeaders = storageUrls.getValue();
        boolean isMailProcessed = false;
        try (ByteArrayOutputStream mailStream = this.processFile.processStreamFromParts(mail);){
            if (UrlStringUtils.isExternalUrl((String)storageUrlEndpoint, hostnames)) {
                this.processExternalUrl(storageUrlEndpoint, mailStream, mailChecksum, mailHeaders);
                isMailProcessed = true;
            } else {
                if (UrlStringUtils.isInternalUrl((String)storageUrlEndpoint, hostnames)) {
                    LOGGER.debug("Internal URL is detected: {}. Do nothing and save the mail in the supplied file path in the StorageUrl.", (Object)storageUrlEndpoint);
                    boolean bl = true;
                    return bl;
                }
                if (UrlStringUtils.isFileUrl((String)storageUrlEndpoint)) {
                    this.processFileUrl(storageUrlEndpoint, mail, mailChecksum, storageUrlGwHeaders);
                    isMailProcessed = true;
                }
            }
            if (isMailProcessed) {
                LOGGER.info("Mail with checksum: {} from {} successfully handled to {}", (Object)mailChecksum, (Object)storageUrlGwHeaders, (Object)storageUrlEndpoint);
                return isMailProcessed;
            }
            LOGGER.warn("Cannot handle mail with checksum {} from {} to {}", (Object)mailChecksum, (Object)storageUrlGwHeaders, (Object)storageUrlEndpoint);
            return isMailProcessed;
        }
        catch (IOException ex) {
            LOGGER.warn("An IOException has occurred for: {} and url: {}. Upload the file manually", (Object)mailChecksum, storageUrls);
            return isMailProcessed;
        }
    }

    private void processExternalUrl(String storageUrlEndpoint, ByteArrayOutputStream mailOutputStream, String mailChecksum, Map<String, String> mailHeaders) throws IOException {
        LOGGER.debug("Processing external URL: {} with bearer token authorization", (Object)storageUrlEndpoint);
        BennoHeaderUtils.createBearerTokenHeader((String)mailChecksum, mailHeaders, (String)this.jwtConfig.getSharedSecret(), (long)this.jwtConfig.getExpirationMinutes());
        this.restUploadMail.uploadMail((InputStream)new ByteArrayInputStream(mailOutputStream.toByteArray()), storageUrlEndpoint, mailHeaders, mailChecksum);
        this.endpointCounter.incrementEndpointCounter();
    }

    private void processFileUrl(String storageUrlEndpoint, Mail mail, String mailChecksum, String[] bennoGwHeaders) throws FileIsAlreadyWrittenException, IOException {
        String inboxSavePath = UrlStringUtils.getFileUrlPath((String)storageUrlEndpoint);
        this.processFile.processFile(mail, inboxSavePath, bennoGwHeaders, mailChecksum);
        this.endpointCounter.incrementEndpointCounter();
    }
}

