/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.rest.utils;

import de.lwsystems.mailarchive.bennoimport.rest.records.BasicAuthRecord;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class BasicAuthUtils {
    private BasicAuthUtils() {
    }

    public static BasicAuthRecord extractCredentials(String basicAuthHeader) {
        if (basicAuthHeader == null || !basicAuthHeader.startsWith("Basic ")) {
            return null;
        }
        String base64Credentials = basicAuthHeader.substring(6).trim();
        String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
        String[] parts = credentials.split(":", 2);
        if (parts.length < 2) {
            return null;
        }
        return new BasicAuthRecord(parts[0], parts[1]);
    }
}

