/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.bennoimport.smtp;

import de.lwsystems.mailarchive.bennoimport.smtp.smtp.SMTPServerBuilder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.subethamail.smtp.server.SMTPServer;

public class Main {
    private static final Logger LOGGER = LogManager.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            String configPath = Main.parseConfigPath(args);
            SMTPServer server = new SMTPServerBuilder().withConfigPath(configPath).build();
            server.start();
        }
        catch (Exception e) {
            LOGGER.error("Error occurred: ", (Throwable)e);
        }
    }

    private static String parseConfigPath(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(Option.builder((String)"c").argName("CONFIG").longOpt("configuration file").desc("Add a configuration file").hasArg().type(String.class).build());
        CommandLine cmdl = parser.parse(options, args, true);
        if (cmdl.hasOption("c")) {
            return cmdl.getOptionValue("c");
        }
        throw new IllegalArgumentException("No configuration file was set in command line");
    }
}

